/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.vehiclerental.street;

import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.routing.api.request.preference.VehicleRentalPreferences;
import org.opentripplanner.service.vehiclerental.street.VehicleRentalPlaceVertex;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateEditor;

public class StreetVehicleRentalLink
extends Edge {
    private final VehicleRentalPlaceVertex vehicleRentalPlaceVertex;

    private StreetVehicleRentalLink(StreetVertex fromv, VehicleRentalPlaceVertex tov) {
        super(fromv, tov);
        this.vehicleRentalPlaceVertex = tov;
    }

    private StreetVehicleRentalLink(VehicleRentalPlaceVertex fromv, StreetVertex tov) {
        super(fromv, tov);
        this.vehicleRentalPlaceVertex = fromv;
    }

    public static StreetVehicleRentalLink createStreetVehicleRentalLink(StreetVertex fromv, VehicleRentalPlaceVertex tov) {
        return StreetVehicleRentalLink.connectToGraph(new StreetVehicleRentalLink(fromv, tov));
    }

    public static StreetVehicleRentalLink createStreetVehicleRentalLink(VehicleRentalPlaceVertex fromv, StreetVertex tov) {
        return StreetVehicleRentalLink.connectToGraph(new StreetVehicleRentalLink(fromv, tov));
    }

    public State[] traverse(State s0) {
        if (s0.getBackEdge() instanceof StreetVehicleRentalLink) {
            return State.empty();
        }
        VehicleRentalPreferences preferences = s0.getPreferences().rental(s0.getRequest().mode());
        if (preferences != null && this.vehicleRentalPlaceVertex.getStation().networkIsNotAllowed(preferences)) {
            return State.empty();
        }
        StateEditor s1 = s0.edit(this);
        s1.incrementWeight(1.0);
        s1.setBackMode(null);
        return s1.makeStateArray();
    }

    @Override
    public I18NString getName() {
        return this.vehicleRentalPlaceVertex.getName();
    }
}

