/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.vehiclerental.street;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.street.model.RentalRestrictionExtension;
import org.opentripplanner.street.search.state.State;

public final class CompositeRentalRestrictionExtension
implements RentalRestrictionExtension {
    private final RentalRestrictionExtension[] extensions;

    private CompositeRentalRestrictionExtension(RentalRestrictionExtension ... extensions) {
        for (RentalRestrictionExtension ext : extensions) {
            if (!(ext instanceof CompositeRentalRestrictionExtension)) continue;
            throw new IllegalArgumentException("Composite extension cannot be nested into one another.");
        }
        HashSet<RentalRestrictionExtension> set = new HashSet<RentalRestrictionExtension>(Arrays.asList(extensions));
        this.extensions = (RentalRestrictionExtension[])set.toArray(RentalRestrictionExtension[]::new);
    }

    @Override
    public boolean traversalBanned(State state) {
        for (RentalRestrictionExtension ext : this.extensions) {
            if (!ext.traversalBanned(state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean dropOffBanned(State state) {
        for (RentalRestrictionExtension ext : this.extensions) {
            if (!ext.dropOffBanned(state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<RentalRestrictionExtension.RestrictionType> debugTypes() {
        EnumSet<RentalRestrictionExtension.RestrictionType> set = EnumSet.noneOf(RentalRestrictionExtension.RestrictionType.class);
        for (RentalRestrictionExtension ext : this.extensions) {
            set.addAll(ext.debugTypes());
        }
        return set;
    }

    @Override
    public RentalRestrictionExtension add(RentalRestrictionExtension other) {
        return CompositeRentalRestrictionExtension.of(this, other);
    }

    public static RentalRestrictionExtension of(RentalRestrictionExtension ... exts) {
        Set set = Arrays.stream(exts).flatMap(e -> e.toList().stream()).collect(Collectors.toSet());
        if (set.size() == 1) {
            return (RentalRestrictionExtension)List.copyOf(set).get(0);
        }
        return new CompositeRentalRestrictionExtension((RentalRestrictionExtension[])set.toArray(RentalRestrictionExtension[]::new));
    }

    @Override
    public RentalRestrictionExtension remove(RentalRestrictionExtension toRemove) {
        RentalRestrictionExtension[] newExts = (RentalRestrictionExtension[])Arrays.stream(this.extensions).filter(e -> !e.equals(toRemove)).toArray(RentalRestrictionExtension[]::new);
        if (newExts.length == 0) {
            return null;
        }
        return CompositeRentalRestrictionExtension.of(newExts);
    }

    @Override
    public List<RentalRestrictionExtension> toList() {
        return List.copyOf(Arrays.asList(this.extensions));
    }

    @Override
    public boolean hasRestrictions() {
        return this.extensions.length > 0;
    }

    @Override
    public Set<String> noDropOffNetworks() {
        return Arrays.stream(this.extensions).flatMap(e -> e.noDropOffNetworks().stream()).collect(Collectors.toSet());
    }

    @Override
    public List<String> networks() {
        return Arrays.stream(this.extensions).flatMap(e -> e.networks().stream()).toList();
    }
}

