/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.vehiclerental.model;

import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.service.vehiclerental.model.RentalVehicleFuel;
import org.opentripplanner.service.vehiclerental.model.RentalVehicleType;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalPlace;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalStationUris;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalSystem;
import org.opentripplanner.street.model.RentalFormFactor;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public final class VehicleRentalVehicle
implements VehicleRentalPlace {
    public static final VehicleRentalVehicle DEFAULT = new VehicleRentalVehicle();
    private final FeedScopedId id;
    private final I18NString name;
    private final double longitude;
    private final double latitude;
    private final VehicleRentalSystem system;
    private final RentalVehicleType vehicleType;
    private final VehicleRentalStationUris rentalUris;
    private final boolean isReserved;
    private final boolean isDisabled;
    private final RentalVehicleFuel fuel;
    private final OffsetDateTime availableUntil;

    public VehicleRentalVehicle() {
        this.id = null;
        this.name = null;
        this.longitude = 0.0;
        this.latitude = 0.0;
        this.system = null;
        this.vehicleType = null;
        this.rentalUris = null;
        this.isReserved = false;
        this.isDisabled = false;
        this.fuel = null;
        this.availableUntil = null;
    }

    private VehicleRentalVehicle(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.longitude = builder.longitude;
        this.latitude = builder.latitude;
        this.system = builder.system;
        this.vehicleType = builder.vehicleType;
        this.rentalUris = builder.rentalUris;
        this.isReserved = builder.isReserved;
        this.isDisabled = builder.isDisabled;
        this.fuel = builder.fuel;
        this.availableUntil = builder.availableUntil;
    }

    public static Builder of() {
        return DEFAULT.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    @Override
    public FeedScopedId id() {
        return this.id;
    }

    @Override
    @Nullable
    public I18NString name() {
        return this.name;
    }

    @Override
    public double longitude() {
        return this.longitude;
    }

    @Override
    public double latitude() {
        return this.latitude;
    }

    @Nullable
    public VehicleRentalSystem system() {
        return this.system;
    }

    @Nullable
    public RentalVehicleType vehicleType() {
        return this.vehicleType;
    }

    @Override
    @Nullable
    public VehicleRentalStationUris rentalUris() {
        return this.rentalUris;
    }

    public boolean isReserved() {
        return this.isReserved;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    @Nullable
    public RentalVehicleFuel fuel() {
        return this.fuel;
    }

    @Override
    public String stationId() {
        return this.id().getId();
    }

    @Override
    public String network() {
        return this.id().getFeedId();
    }

    @Override
    public int vehiclesAvailable() {
        return 1;
    }

    @Override
    public int spacesAvailable() {
        return 0;
    }

    @Override
    public Integer capacity() {
        return 0;
    }

    @Override
    public boolean isAllowDropoff() {
        return false;
    }

    @Override
    public boolean overloadingAllowed() {
        return false;
    }

    @Override
    public boolean isAllowPickup() {
        return !this.isDisabled;
    }

    @Override
    public boolean allowPickupNow() {
        return !this.isReserved && !this.isDisabled;
    }

    @Override
    public boolean allowDropoffNow() {
        return false;
    }

    @Override
    public boolean isFloatingVehicle() {
        return true;
    }

    @Override
    public boolean isCarStation() {
        return this.vehicleType.formFactor().equals((Object)RentalFormFactor.CAR);
    }

    @Override
    public Set<RentalFormFactor> availablePickupFormFactors(boolean includeRealtimeAvailability) {
        return Set.of(this.vehicleType.formFactor());
    }

    @Override
    public Set<RentalFormFactor> availableDropoffFormFactors(boolean includeRealtimeAvailability) {
        return Set.of();
    }

    @Override
    public boolean isArrivingInRentalVehicleAtDestinationAllowed() {
        return false;
    }

    @Override
    public boolean isRealTimeData() {
        return true;
    }

    @Override
    public VehicleRentalSystem vehicleRentalSystem() {
        return this.system;
    }

    public RentalVehicleFuel getFuel() {
        return this.fuel;
    }

    public OffsetDateTime availableUntil() {
        return this.availableUntil;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VehicleRentalVehicle that = (VehicleRentalVehicle)o;
        return Double.compare(that.longitude, this.longitude) == 0 && Double.compare(that.latitude, this.latitude) == 0 && this.isReserved == that.isReserved && this.isDisabled == that.isDisabled && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.system, that.system) && Objects.equals(this.vehicleType, that.vehicleType) && Objects.equals(this.rentalUris, that.rentalUris) && Objects.equals(this.fuel, that.fuel) && Objects.equals(this.availableUntil, that.availableUntil);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.longitude, this.latitude, this.system, this.vehicleType, this.rentalUris, this.isReserved, this.isDisabled, this.fuel, this.availableUntil);
    }

    public String toString() {
        return ToStringBuilder.of(VehicleRentalVehicle.class).addObj("id", (Object)this.id, (Object)VehicleRentalVehicle.DEFAULT.id).addObj("name", (Object)this.name, (Object)VehicleRentalVehicle.DEFAULT.name).addNum("longitude", (Number)this.longitude, (Number)VehicleRentalVehicle.DEFAULT.longitude).addNum("latitude", (Number)this.latitude, (Number)VehicleRentalVehicle.DEFAULT.latitude).addObj("system", (Object)this.system, (Object)VehicleRentalVehicle.DEFAULT.system).addObj("vehicleType", (Object)this.vehicleType, (Object)VehicleRentalVehicle.DEFAULT.vehicleType).addObj("rentalUris", (Object)this.rentalUris, (Object)VehicleRentalVehicle.DEFAULT.rentalUris).addBoolIfTrue("isReserved", Boolean.valueOf(this.isReserved)).addBoolIfTrue("isDisabled", Boolean.valueOf(this.isDisabled)).addObj("fuel", (Object)this.fuel, (Object)VehicleRentalVehicle.DEFAULT.fuel).addObj("availableUntil", (Object)this.availableUntil, (Object)VehicleRentalVehicle.DEFAULT.availableUntil).toString();
    }

    public static class Builder {
        private final VehicleRentalVehicle original;
        private FeedScopedId id;
        private I18NString name;
        private double longitude;
        private double latitude;
        private VehicleRentalSystem system;
        private RentalVehicleType vehicleType;
        private VehicleRentalStationUris rentalUris;
        private boolean isReserved;
        private boolean isDisabled;
        private RentalVehicleFuel fuel;
        private OffsetDateTime availableUntil;

        private Builder(VehicleRentalVehicle original) {
            this.original = original;
            this.id = original.id;
            this.name = original.name;
            this.longitude = original.longitude;
            this.latitude = original.latitude;
            this.system = original.system;
            this.vehicleType = original.vehicleType;
            this.rentalUris = original.rentalUris;
            this.isReserved = original.isReserved;
            this.isDisabled = original.isDisabled;
            this.fuel = original.fuel;
            this.availableUntil = original.availableUntil;
        }

        public Builder withId(FeedScopedId id) {
            this.id = id;
            return this;
        }

        public Builder withName(@Nullable I18NString name) {
            this.name = name;
            return this;
        }

        public Builder withLongitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        public Builder withLatitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        public Builder withSystem(@Nullable VehicleRentalSystem system) {
            this.system = system;
            return this;
        }

        public Builder withVehicleType(@Nullable RentalVehicleType vehicleType) {
            this.vehicleType = vehicleType;
            return this;
        }

        public Builder withRentalUris(@Nullable VehicleRentalStationUris rentalUris) {
            this.rentalUris = rentalUris;
            return this;
        }

        public Builder withIsReserved(boolean isReserved) {
            this.isReserved = isReserved;
            return this;
        }

        public Builder withIsDisabled(boolean isDisabled) {
            this.isDisabled = isDisabled;
            return this;
        }

        public Builder withFuel(@Nullable RentalVehicleFuel fuel) {
            this.fuel = fuel;
            return this;
        }

        public Builder withAvailableUntil(@Nullable OffsetDateTime availableUntil) {
            this.availableUntil = availableUntil;
            return this;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        public VehicleRentalVehicle build() {
            VehicleRentalVehicle value = new VehicleRentalVehicle(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

