/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.vehiclerental.model;

import java.util.Objects;
import javax.annotation.Nullable;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public final class VehicleRentalSystem {
    public static final VehicleRentalSystem DEFAULT = new VehicleRentalSystem();
    @Nullable
    private final String systemId;
    @Nullable
    private final I18NString name;
    @Nullable
    private final I18NString shortName;
    @Nullable
    private final I18NString operator;
    @Nullable
    private final String url;

    private VehicleRentalSystem() {
        this.systemId = null;
        this.name = null;
        this.shortName = null;
        this.operator = null;
        this.url = null;
    }

    private VehicleRentalSystem(Builder builder) {
        this.systemId = builder.systemId;
        this.name = builder.name;
        this.shortName = builder.shortName;
        this.operator = builder.operator;
        this.url = builder.url;
    }

    public VehicleRentalSystem(String systemId, I18NString name, I18NString shortName, I18NString operator, String url) {
        this.systemId = systemId;
        this.name = name;
        this.shortName = shortName;
        this.operator = operator;
        this.url = url;
    }

    public static Builder of() {
        return DEFAULT.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    @Nullable
    public String systemId() {
        return this.systemId;
    }

    @Nullable
    public I18NString name() {
        return this.name;
    }

    @Nullable
    public I18NString shortName() {
        return this.shortName;
    }

    @Nullable
    public I18NString operator() {
        return this.operator;
    }

    @Nullable
    public String url() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VehicleRentalSystem that = (VehicleRentalSystem)o;
        return Objects.equals(this.systemId, that.systemId) && Objects.equals(this.name, that.name) && Objects.equals(this.shortName, that.shortName) && Objects.equals(this.operator, that.operator) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.systemId, this.name, this.shortName, this.operator, this.url);
    }

    public String toString() {
        return ToStringBuilder.of(VehicleRentalSystem.class).addStr("systemId", this.systemId, VehicleRentalSystem.DEFAULT.systemId).addObj("name", (Object)this.name, (Object)VehicleRentalSystem.DEFAULT.name).addObj("shortName", (Object)this.shortName, (Object)VehicleRentalSystem.DEFAULT.shortName).addObj("operator", (Object)this.operator, (Object)VehicleRentalSystem.DEFAULT.operator).addStr("url", this.url, VehicleRentalSystem.DEFAULT.url).toString();
    }

    public static class Builder {
        private final VehicleRentalSystem original;
        private String systemId;
        private I18NString name;
        private I18NString shortName;
        private I18NString operator;
        private String url;

        private Builder(VehicleRentalSystem original) {
            this.original = original;
            this.systemId = original.systemId;
            this.name = original.name;
            this.shortName = original.shortName;
            this.operator = original.operator;
            this.url = original.url;
        }

        public Builder withSystemId(@Nullable String systemId) {
            this.systemId = systemId;
            return this;
        }

        public I18NString name() {
            return this.name;
        }

        public Builder withName(@Nullable I18NString name) {
            this.name = name;
            return this;
        }

        public I18NString shortName() {
            return this.shortName;
        }

        public Builder withShortName(@Nullable I18NString shortName) {
            this.shortName = shortName;
            return this;
        }

        public I18NString operator() {
            return this.operator;
        }

        public Builder withOperator(@Nullable I18NString operator) {
            this.operator = operator;
            return this;
        }

        public String url() {
            return this.url;
        }

        public Builder withUrl(@Nullable String url) {
            this.url = url;
            return this;
        }

        public VehicleRentalSystem build() {
            VehicleRentalSystem value = new VehicleRentalSystem(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

