/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.vehiclerental.model;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.service.vehiclerental.model.RentalVehicleEntityCounts;
import org.opentripplanner.service.vehiclerental.model.RentalVehicleType;
import org.opentripplanner.service.vehiclerental.model.RentalVehicleTypeCount;
import org.opentripplanner.service.vehiclerental.model.ReturnPolicy;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalPlace;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalStationBuilder;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalStationUris;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalSystem;
import org.opentripplanner.street.model.RentalFormFactor;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.utils.collection.SetUtils;

public final class VehicleRentalStation
implements VehicleRentalPlace {
    public static final VehicleRentalStation DEFAULT = new VehicleRentalStation();
    private final FeedScopedId id;
    private final I18NString name;
    private final double longitude;
    private final double latitude;
    private final Integer capacity;
    private final Map<RentalVehicleType, Integer> vehicleTypeAreaCapacity;
    private final Map<RentalVehicleType, Integer> vehicleTypeDockCapacity;
    private final VehicleRentalSystem system;
    private final VehicleRentalStationUris rentalUris;
    private final int vehiclesAvailable;
    private final int vehiclesDisabled;
    private final Map<RentalVehicleType, Integer> vehicleTypesAvailable;
    private final int spacesAvailable;
    private final int spacesDisabled;
    private final Map<RentalVehicleType, Integer> vehicleSpacesAvailable;
    private final boolean isRenting;
    private final boolean isReturning;
    private final boolean overloadingAllowed;
    private final boolean isArrivingInRentalVehicleAtDestinationAllowed;
    private final boolean realTimeData;
    private final ReturnPolicy returnPolicy;

    public VehicleRentalStation() {
        this.id = null;
        this.name = null;
        this.longitude = 0.0;
        this.latitude = 0.0;
        this.capacity = null;
        this.vehicleTypeAreaCapacity = Map.of();
        this.vehicleTypeDockCapacity = Map.of();
        this.system = null;
        this.rentalUris = null;
        this.vehiclesAvailable = 0;
        this.vehiclesDisabled = 0;
        this.vehicleTypesAvailable = Map.of();
        this.spacesAvailable = 0;
        this.spacesDisabled = 0;
        this.vehicleSpacesAvailable = Map.of();
        this.isRenting = true;
        this.isReturning = true;
        this.overloadingAllowed = false;
        this.isArrivingInRentalVehicleAtDestinationAllowed = false;
        this.realTimeData = true;
        this.returnPolicy = ReturnPolicy.SPECIFIC_TYPES;
    }

    VehicleRentalStation(VehicleRentalStationBuilder builder) {
        this.id = builder.id();
        this.name = builder.name();
        this.longitude = builder.longitude();
        this.latitude = builder.latitude();
        this.capacity = builder.capacity();
        this.vehicleTypeAreaCapacity = Map.copyOf(builder.vehicleTypeAreaCapacity());
        this.vehicleTypeDockCapacity = Map.copyOf(builder.vehicleTypeDockCapacity());
        this.system = builder.system();
        this.rentalUris = builder.rentalUris();
        this.vehiclesAvailable = builder.vehiclesAvailable();
        this.vehiclesDisabled = builder.vehiclesDisabled();
        this.vehicleTypesAvailable = Map.copyOf(builder.vehicleTypesAvailable());
        this.spacesAvailable = builder.spacesAvailable();
        this.spacesDisabled = builder.spacesDisabled();
        this.vehicleSpacesAvailable = Map.copyOf(builder.vehicleSpacesAvailable());
        this.isRenting = builder.isRenting();
        this.isReturning = builder.isReturning();
        this.overloadingAllowed = builder.isOverloadingAllowed();
        this.isArrivingInRentalVehicleAtDestinationAllowed = builder.isArrivingInRentalVehicleAtDestinationAllowed();
        this.realTimeData = builder.isRealTimeData();
        this.returnPolicy = builder.returnPolicy();
    }

    public static VehicleRentalStationBuilder of() {
        return DEFAULT.copyOf();
    }

    public VehicleRentalStationBuilder copyOf() {
        return new VehicleRentalStationBuilder(this);
    }

    @Override
    @Nullable
    public FeedScopedId id() {
        return this.id;
    }

    @Override
    @Nullable
    public I18NString name() {
        return this.name;
    }

    @Override
    public double longitude() {
        return this.longitude;
    }

    @Override
    public double latitude() {
        return this.latitude;
    }

    @Override
    @Nullable
    public Integer capacity() {
        return this.capacity;
    }

    public Map<RentalVehicleType, Integer> vehicleTypeAreaCapacity() {
        return this.vehicleTypeAreaCapacity;
    }

    public Map<RentalVehicleType, Integer> vehicleTypeDockCapacity() {
        return this.vehicleTypeDockCapacity;
    }

    @Nullable
    public VehicleRentalSystem system() {
        return this.system;
    }

    @Override
    @Nullable
    public VehicleRentalStationUris rentalUris() {
        return this.rentalUris;
    }

    @Override
    public int vehiclesAvailable() {
        return this.vehiclesAvailable;
    }

    public int vehiclesDisabled() {
        return this.vehiclesDisabled;
    }

    public Map<RentalVehicleType, Integer> vehicleTypesAvailable() {
        return this.vehicleTypesAvailable;
    }

    @Override
    public int spacesAvailable() {
        return this.spacesAvailable;
    }

    public int spacesDisabled() {
        return this.spacesDisabled;
    }

    public Map<RentalVehicleType, Integer> vehicleSpacesAvailable() {
        return this.vehicleSpacesAvailable;
    }

    public boolean isRenting() {
        return this.isRenting;
    }

    public boolean isReturning() {
        return this.isReturning;
    }

    public boolean realTimeData() {
        return this.realTimeData;
    }

    @Override
    public String stationId() {
        return this.id().getId();
    }

    @Override
    public String network() {
        return this.id().getFeedId();
    }

    @Override
    public boolean isAllowDropoff() {
        return this.isReturning;
    }

    @Override
    public boolean isAllowPickup() {
        return this.isRenting;
    }

    @Override
    public boolean allowPickupNow() {
        return this.isRenting && this.vehiclesAvailable > 0;
    }

    @Override
    public boolean allowDropoffNow() {
        return this.isReturning && (this.spacesAvailable > 0 || this.overloadingAllowed);
    }

    @Override
    public boolean isFloatingVehicle() {
        return false;
    }

    @Override
    public boolean isCarStation() {
        return Stream.concat(this.vehicleTypesAvailable.keySet().stream(), this.vehicleSpacesAvailable.keySet().stream()).anyMatch(rentalVehicleType -> rentalVehicleType.formFactor().equals((Object)RentalFormFactor.CAR));
    }

    @Override
    public Set<RentalFormFactor> availablePickupFormFactors(boolean includeRealtimeAvailability) {
        return this.vehicleTypesAvailable.entrySet().stream().filter(e -> !includeRealtimeAvailability || (Integer)e.getValue() > 0).map(e -> ((RentalVehicleType)e.getKey()).formFactor()).collect(Collectors.toSet());
    }

    @Override
    public Set<RentalFormFactor> availableDropoffFormFactors(boolean includeRealtimeAvailability) {
        return this.vehicleSpacesAvailable.entrySet().stream().filter(e -> !includeRealtimeAvailability || this.overloadingAllowed || (Integer)e.getValue() > 0).map(e -> ((RentalVehicleType)e.getKey()).formFactor()).collect(Collectors.toSet());
    }

    @Override
    public boolean canDropOffFormFactor(RentalFormFactor formFactor, boolean includeRealtimeAvailability) {
        if (this.returnPolicy.equals((Object)ReturnPolicy.ANY_TYPE) && includeRealtimeAvailability) {
            return this.allowDropoffNow();
        }
        if (this.returnPolicy.equals((Object)ReturnPolicy.ANY_TYPE)) {
            return true;
        }
        return this.availableDropoffFormFactors(includeRealtimeAvailability).contains((Object)formFactor);
    }

    @Override
    public boolean isArrivingInRentalVehicleAtDestinationAllowed() {
        return this.isArrivingInRentalVehicleAtDestinationAllowed;
    }

    @Override
    public boolean overloadingAllowed() {
        return this.overloadingAllowed;
    }

    @Override
    public boolean isRealTimeData() {
        return this.realTimeData;
    }

    @Override
    public VehicleRentalSystem vehicleRentalSystem() {
        return this.system;
    }

    public String toString() {
        return String.format(Locale.ROOT, "Vehicle rental station %s at %.6f, %.6f", this.name, this.latitude, this.longitude);
    }

    public Set<RentalFormFactor> formFactors() {
        return SetUtils.combine((Collection[])new Collection[]{this.availableDropoffFormFactors(false), this.availablePickupFormFactors(false)});
    }

    public RentalVehicleEntityCounts vehicleTypeCounts() {
        return new RentalVehicleEntityCounts(this.vehiclesAvailable, this.vehicleRentalTypeMapToList(this.vehicleTypesAvailable));
    }

    public RentalVehicleEntityCounts vehicleSpaceCounts() {
        return new RentalVehicleEntityCounts(this.spacesAvailable, this.vehicleRentalTypeMapToList(this.vehicleSpacesAvailable));
    }

    public ReturnPolicy returnPolicy() {
        return this.returnPolicy;
    }

    private List<RentalVehicleTypeCount> vehicleRentalTypeMapToList(Map<RentalVehicleType, Integer> vehicleTypeMap) {
        return vehicleTypeMap.entrySet().stream().map(vtc -> new RentalVehicleTypeCount((RentalVehicleType)vtc.getKey(), (Integer)vtc.getValue())).sorted(Comparator.comparing(RentalVehicleTypeCount::vehicleType)).toList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VehicleRentalStation that = (VehicleRentalStation)o;
        return Double.compare(that.longitude, this.longitude) == 0 && Double.compare(that.latitude, this.latitude) == 0 && this.vehiclesAvailable == that.vehiclesAvailable && this.vehiclesDisabled == that.vehiclesDisabled && this.spacesAvailable == that.spacesAvailable && this.spacesDisabled == that.spacesDisabled && this.isRenting == that.isRenting && this.isReturning == that.isReturning && this.overloadingAllowed == that.overloadingAllowed && this.isArrivingInRentalVehicleAtDestinationAllowed == that.isArrivingInRentalVehicleAtDestinationAllowed && this.realTimeData == that.realTimeData && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.capacity, that.capacity) && Objects.equals(this.vehicleTypeAreaCapacity, that.vehicleTypeAreaCapacity) && Objects.equals(this.vehicleTypeDockCapacity, that.vehicleTypeDockCapacity) && Objects.equals(this.system, that.system) && Objects.equals(this.rentalUris, that.rentalUris) && Objects.equals(this.vehicleTypesAvailable, that.vehicleTypesAvailable) && Objects.equals(this.vehicleSpacesAvailable, that.vehicleSpacesAvailable);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.longitude, this.latitude, this.capacity, this.vehicleTypeAreaCapacity, this.vehicleTypeDockCapacity, this.system, this.rentalUris, this.vehiclesAvailable, this.vehiclesDisabled, this.vehicleTypesAvailable, this.spacesAvailable, this.spacesDisabled, this.vehicleSpacesAvailable, this.isRenting, this.isReturning, this.overloadingAllowed, this.isArrivingInRentalVehicleAtDestinationAllowed, this.realTimeData);
    }
}

