/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.vehiclerental.model;

import java.util.Set;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.routing.api.request.preference.VehicleRentalPreferences;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalStationUris;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalSystem;
import org.opentripplanner.street.model.RentalFormFactor;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public interface VehicleRentalPlace {
    public FeedScopedId id();

    public String stationId();

    public String network();

    public I18NString name();

    public double longitude();

    public double latitude();

    public int vehiclesAvailable();

    public int spacesAvailable();

    public Integer capacity();

    public boolean isAllowDropoff();

    public boolean overloadingAllowed();

    public boolean isAllowPickup();

    public boolean allowPickupNow();

    public boolean allowDropoffNow();

    public boolean isFloatingVehicle();

    public boolean isCarStation();

    public Set<RentalFormFactor> availablePickupFormFactors(boolean var1);

    public Set<RentalFormFactor> availableDropoffFormFactors(boolean var1);

    default public boolean canDropOffFormFactor(RentalFormFactor formFactor, boolean includeRealtimeAvailability) {
        return false;
    }

    public boolean isArrivingInRentalVehicleAtDestinationAllowed();

    public boolean isRealTimeData();

    public VehicleRentalStationUris rentalUris();

    public VehicleRentalSystem vehicleRentalSystem();

    default public boolean networkIsNotAllowed(VehicleRentalPreferences preferences) {
        if (!(this.network() != null || preferences.allowedNetworks().isEmpty() && preferences.bannedNetworks().isEmpty())) {
            return false;
        }
        if (preferences.bannedNetworks().contains(this.network())) {
            return true;
        }
        if (preferences.allowedNetworks().isEmpty()) {
            return false;
        }
        return !preferences.allowedNetworks().contains(this.network());
    }
}

