/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.vehiclerental.model;

import java.util.Objects;
import javax.annotation.Nullable;
import org.opentripplanner.transit.model.basic.Distance;
import org.opentripplanner.transit.model.basic.Ratio;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public final class RentalVehicleFuel {
    public static final RentalVehicleFuel DEFAULT = new RentalVehicleFuel();
    @Nullable
    private final Ratio percent;
    @Nullable
    private final Distance range;

    private RentalVehicleFuel() {
        this.percent = null;
        this.range = null;
    }

    private RentalVehicleFuel(Builder builder) {
        this.percent = builder.percent;
        this.range = builder.range;
    }

    public static Builder of() {
        return DEFAULT.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    @Nullable
    public Ratio percent() {
        return this.percent;
    }

    @Nullable
    public Distance range() {
        return this.range;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RentalVehicleFuel that = (RentalVehicleFuel)o;
        return Objects.equals(this.percent, that.percent) && Objects.equals(this.range, that.range);
    }

    public int hashCode() {
        return Objects.hash(this.percent, this.range);
    }

    public String toString() {
        return ToStringBuilder.of(RentalVehicleFuel.class).addObj("percent", (Object)this.percent, (Object)RentalVehicleFuel.DEFAULT.percent).addObj("range", (Object)this.range, (Object)RentalVehicleFuel.DEFAULT.range).toString();
    }

    public static class Builder {
        private final RentalVehicleFuel original;
        private Ratio percent;
        private Distance range;

        private Builder(RentalVehicleFuel original) {
            this.original = original;
            this.percent = original.percent;
            this.range = original.range;
        }

        public Builder withPercent(@Nullable Ratio percent) {
            this.percent = percent;
            return this;
        }

        public Builder withRange(@Nullable Distance range) {
            this.range = range;
            return this;
        }

        public RentalVehicleFuel build() {
            RentalVehicleFuel value = new RentalVehicleFuel(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

