/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.vehiclerental.internal;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.service.vehiclerental.VehicleRentalRepository;
import org.opentripplanner.service.vehiclerental.VehicleRentalService;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalPlace;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalStation;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalVehicle;
import org.opentripplanner.street.model.RentalFormFactor;
import org.opentripplanner.transit.model.framework.FeedScopedId;

@Singleton
public class DefaultVehicleRentalService
implements VehicleRentalService,
VehicleRentalRepository {
    private final Map<FeedScopedId, VehicleRentalPlace> rentalPlaces = new ConcurrentHashMap<FeedScopedId, VehicleRentalPlace>();

    @Inject
    public DefaultVehicleRentalService() {
    }

    @Override
    public Collection<VehicleRentalPlace> getVehicleRentalPlaces() {
        return this.rentalPlaces.values();
    }

    @Override
    public VehicleRentalPlace getVehicleRentalPlace(FeedScopedId id) {
        return this.rentalPlaces.get(id);
    }

    @Override
    public List<VehicleRentalVehicle> getVehicleRentalVehicles() {
        return this.rentalPlaces.values().stream().filter(VehicleRentalVehicle.class::isInstance).map(VehicleRentalVehicle.class::cast).toList();
    }

    @Override
    public VehicleRentalVehicle getVehicleRentalVehicle(FeedScopedId id) {
        VehicleRentalVehicle vehicleRentalVehicle;
        VehicleRentalPlace vehicleRentalPlace = this.rentalPlaces.get(id);
        return vehicleRentalPlace instanceof VehicleRentalVehicle ? (vehicleRentalVehicle = (VehicleRentalVehicle)vehicleRentalPlace) : null;
    }

    @Override
    public List<VehicleRentalStation> getVehicleRentalStations() {
        return this.getVehicleRentalStationsAsStream().toList();
    }

    @Override
    public VehicleRentalStation getVehicleRentalStation(FeedScopedId id) {
        VehicleRentalStation vehicleRentalStation;
        VehicleRentalPlace vehicleRentalPlace = this.rentalPlaces.get(id);
        return vehicleRentalPlace instanceof VehicleRentalStation ? (vehicleRentalStation = (VehicleRentalStation)vehicleRentalPlace) : null;
    }

    @Override
    public void addVehicleRentalStation(VehicleRentalPlace vehicleRentalStation) {
        this.rentalPlaces.put(vehicleRentalStation.id(), vehicleRentalStation);
    }

    @Override
    public void removeVehicleRentalStation(FeedScopedId vehicleRentalStationId) {
        this.rentalPlaces.remove(vehicleRentalStationId);
    }

    @Override
    public boolean hasRentalBikes() {
        return this.rentalPlaces.values().stream().anyMatch(place -> {
            if (place instanceof VehicleRentalVehicle) {
                VehicleRentalVehicle vehicle = (VehicleRentalVehicle)place;
                return vehicle.vehicleType().formFactor() == RentalFormFactor.BICYCLE;
            }
            if (place instanceof VehicleRentalStation) {
                VehicleRentalStation station = (VehicleRentalStation)place;
                return station.vehicleTypesAvailable().keySet().stream().anyMatch(t -> t.formFactor() == RentalFormFactor.BICYCLE);
            }
            return false;
        });
    }

    @Override
    public List<VehicleRentalStation> getVehicleRentalStationForEnvelope(double minLon, double minLat, double maxLon, double maxLat) {
        Envelope envelope = new Envelope(new Coordinate(minLon, minLat), new Coordinate(maxLon, maxLat));
        return this.getVehicleRentalStationsAsStream().filter(b -> envelope.contains(new Coordinate(b.longitude(), b.latitude()))).toList();
    }

    private Stream<VehicleRentalStation> getVehicleRentalStationsAsStream() {
        return this.rentalPlaces.values().stream().filter(VehicleRentalStation.class::isInstance).map(VehicleRentalStation.class::cast);
    }

    @Override
    public List<VehicleRentalPlace> getVehicleRentalPlacesForEnvelope(Envelope envelope) {
        Stream<VehicleRentalPlace> vehicleRentalPlaceStream = this.getVehicleRentalPlaces().stream().filter(vr -> envelope.contains(new Coordinate(vr.longitude(), vr.latitude())));
        return vehicleRentalPlaceStream.toList();
    }
}

