/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.vehicleparking.internal;

import com.google.common.collect.ListMultimap;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.Serializable;
import java.util.Collection;
import org.opentripplanner.service.vehicleparking.VehicleParkingRepository;
import org.opentripplanner.service.vehicleparking.VehicleParkingService;
import org.opentripplanner.service.vehicleparking.model.VehicleParking;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingGroup;

@Singleton
public class DefaultVehicleParkingService
implements Serializable,
VehicleParkingService {
    private final VehicleParkingRepository repository;

    @Inject
    public DefaultVehicleParkingService(VehicleParkingRepository repository) {
        this.repository = repository;
    }

    @Override
    public Collection<VehicleParking> listBikeParks() {
        return this.repository.listVehicleParkings().stream().filter(VehicleParking::hasBicyclePlaces).toList();
    }

    @Override
    public Collection<VehicleParking> listCarParks() {
        return this.repository.listVehicleParkings().stream().filter(VehicleParking::hasAnyCarPlaces).toList();
    }

    @Override
    public Collection<VehicleParking> listVehicleParkings() {
        return this.repository.listVehicleParkings();
    }

    @Override
    public ListMultimap<VehicleParkingGroup, VehicleParking> listVehicleParkingGroups() {
        return this.repository.getVehicleParkingGroups();
    }

    @Override
    public boolean hasBikeParking() {
        return this.repository.listVehicleParkings().stream().anyMatch(VehicleParking::hasBicyclePlaces);
    }

    @Override
    public boolean hasCarParking() {
        return this.repository.listVehicleParkings().stream().anyMatch(VehicleParking::hasAnyCarPlaces);
    }
}

