/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.vehicleparking.internal;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.opentripplanner.service.vehicleparking.VehicleParkingRepository;
import org.opentripplanner.service.vehicleparking.model.VehicleParking;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingGroup;

@Singleton
public class DefaultVehicleParkingRepository
implements VehicleParkingRepository {
    private volatile Set<VehicleParking> vehicleParkings = Set.of();
    private volatile ImmutableListMultimap<VehicleParkingGroup, VehicleParking> vehicleParkingGroups = ImmutableListMultimap.of();

    @Inject
    public DefaultVehicleParkingRepository() {
    }

    @Override
    public void updateVehicleParking(Collection<VehicleParking> parkingToAdd, Collection<VehicleParking> parkingToRemove) {
        ArrayListMultimap updatedVehicleParkingGroups = ArrayListMultimap.create(this.vehicleParkingGroups);
        parkingToRemove.forEach(arg_0 -> DefaultVehicleParkingRepository.lambda$updateVehicleParking$0((Multimap)updatedVehicleParkingGroups, arg_0));
        parkingToAdd.forEach(arg_0 -> DefaultVehicleParkingRepository.lambda$updateVehicleParking$1((Multimap)updatedVehicleParkingGroups, arg_0));
        this.vehicleParkingGroups = ImmutableListMultimap.copyOf((Multimap)updatedVehicleParkingGroups);
        HashSet<VehicleParking> updatedVehicleParkings = new HashSet<VehicleParking>(this.vehicleParkings);
        updatedVehicleParkings.removeAll(parkingToRemove);
        updatedVehicleParkings.addAll(parkingToAdd);
        this.vehicleParkings = Set.copyOf(updatedVehicleParkings);
    }

    @Override
    public Collection<VehicleParking> listVehicleParkings() {
        return Set.copyOf(this.vehicleParkings);
    }

    @Override
    public ListMultimap<VehicleParkingGroup, VehicleParking> getVehicleParkingGroups() {
        return this.vehicleParkingGroups;
    }

    private static /* synthetic */ void lambda$updateVehicleParking$1(Multimap updatedVehicleParkingGroups, VehicleParking vehicleParking) {
        VehicleParkingGroup vehicleParkingGroup = vehicleParking.getVehicleParkingGroup();
        if (vehicleParkingGroup != null) {
            updatedVehicleParkingGroups.put((Object)vehicleParking.getVehicleParkingGroup(), (Object)vehicleParking);
        }
    }

    private static /* synthetic */ void lambda$updateVehicleParking$0(Multimap updatedVehicleParkingGroups, VehicleParking vehicleParking) {
        VehicleParkingGroup vehicleParkingGroup = vehicleParking.getVehicleParkingGroup();
        if (vehicleParkingGroup != null) {
            updatedVehicleParkingGroups.remove((Object)vehicleParking.getVehicleParkingGroup(), (Object)vehicleParking);
        }
    }
}

