/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.realtimevehicles.model;

import java.time.Instant;
import java.util.Optional;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.service.realtimevehicles.model.RealtimeVehicleBuilder;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.OccupancyStatus;
import org.opentripplanner.transit.model.timetable.Trip;

public class RealtimeVehicle {
    private final FeedScopedId vehicleId;
    private final String label;
    private final WgsCoordinate coordinates;
    private final Double speed;
    private final Double heading;
    private final Instant time;
    private final StopRelationship stop;
    private final Trip trip;
    private final OccupancyStatus occupancyStatus;

    RealtimeVehicle(RealtimeVehicleBuilder builder) {
        StopRelationship stopRelationship = Optional.ofNullable(builder.stop()).map(s -> new StopRelationship((StopLocation)s, builder.stopStatus())).orElse(null);
        this.vehicleId = builder.vehicleId();
        this.label = builder.label();
        this.coordinates = builder.coordinates();
        this.speed = builder.speed();
        this.heading = builder.heading();
        this.time = builder.time();
        this.stop = stopRelationship;
        this.trip = builder.trip();
        this.occupancyStatus = builder.occupancyStatus();
    }

    public Optional<FeedScopedId> vehicleId() {
        return Optional.ofNullable(this.vehicleId);
    }

    public Optional<String> label() {
        return Optional.ofNullable(this.label);
    }

    public Optional<WgsCoordinate> coordinates() {
        return Optional.ofNullable(this.coordinates);
    }

    public Optional<Double> speed() {
        return Optional.ofNullable(this.speed);
    }

    public Optional<Double> heading() {
        return Optional.ofNullable(this.heading);
    }

    public Optional<Instant> time() {
        return Optional.ofNullable(this.time);
    }

    public Optional<StopRelationship> stop() {
        return Optional.ofNullable(this.stop);
    }

    public Trip trip() {
        return this.trip;
    }

    public Optional<OccupancyStatus> occupancyStatus() {
        return Optional.ofNullable(this.occupancyStatus);
    }

    public static RealtimeVehicleBuilder builder() {
        return new RealtimeVehicleBuilder();
    }

    public record StopRelationship(StopLocation stop, StopStatus status) {
    }

    public static enum StopStatus {
        INCOMING_AT,
        STOPPED_AT,
        IN_TRANSIT_TO;

    }
}

