/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.realtimevehicles.internal;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import org.opentripplanner.service.realtimevehicles.RealtimeVehicleRepository;
import org.opentripplanner.service.realtimevehicles.RealtimeVehicleService;
import org.opentripplanner.service.realtimevehicles.model.RealtimeVehicle;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.timetable.OccupancyStatus;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.service.TransitService;

@Singleton
public class DefaultRealtimeVehicleService
implements RealtimeVehicleService,
RealtimeVehicleRepository {
    private volatile ImmutableListMultimap<TripPattern, RealtimeVehicle> vehicles = ImmutableListMultimap.of();
    private final TransitService transitService;

    @Inject
    public DefaultRealtimeVehicleService(TransitService transitService) {
        this.transitService = transitService;
    }

    @Override
    public void setRealtimeVehiclesForFeed(String feedId, Multimap<TripPattern, RealtimeVehicle> updates) {
        ArrayListMultimap temp = ArrayListMultimap.create();
        temp.putAll(this.vehicles);
        this.vehicles.keys().stream().filter(p -> p.getFeedId().equals(feedId)).forEach(arg_0 -> ((Multimap)temp).removeAll(arg_0));
        updates.forEach((arg_0, arg_1) -> DefaultRealtimeVehicleService.lambda$setRealtimeVehiclesForFeed$1((Multimap)temp, arg_0, arg_1));
        this.vehicles = ImmutableListMultimap.copyOf((Multimap)temp);
    }

    @Override
    public List<RealtimeVehicle> getRealtimeVehicles(TripPattern pattern) {
        if (pattern.getOriginalTripPattern() != null) {
            pattern = pattern.getOriginalTripPattern();
        }
        return this.vehicles.get((Object)pattern);
    }

    @Override
    public OccupancyStatus getVehicleOccupancyStatus(Trip trip) {
        return this.getOccupancyStatus(trip.getId(), this.transitService.findPattern(trip));
    }

    public OccupancyStatus getOccupancyStatus(FeedScopedId tripId, TripPattern pattern) {
        return this.vehicles.get((Object)pattern).stream().filter(vehicle -> tripId.equals(vehicle.trip().getId())).max(Comparator.comparing(vehicle -> vehicle.time().orElse(Instant.MIN))).flatMap(RealtimeVehicle::occupancyStatus).orElse(OccupancyStatus.NO_DATA_AVAILABLE);
    }

    private static /* synthetic */ void lambda$setRealtimeVehiclesForFeed$1(Multimap temp, TripPattern pattern, RealtimeVehicle vehicles) {
        if (pattern.getOriginalTripPattern() != null) {
            pattern = pattern.getOriginalTripPattern();
        }
        temp.put((Object)pattern, (Object)vehicles);
    }
}

