/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.paging;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.SortOrder;
import org.opentripplanner.model.plan.paging.PagingSearchWindowAdjuster;
import org.opentripplanner.model.plan.paging.cursor.PageCursor;
import org.opentripplanner.model.plan.paging.cursor.PageCursorFactory;
import org.opentripplanner.model.plan.paging.cursor.PageCursorInput;
import org.opentripplanner.model.plan.paging.cursor.PageType;
import org.opentripplanner.routing.api.response.TripSearchMetadata;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class PagingService {
    private final Duration searchWindowUsed;
    private final Instant earliestDepartureTime;
    private final Instant latestArrivalTime;
    private final SortOrder itinerariesSortOrder;
    private final boolean arriveBy;
    private final int numberOfItineraries;
    private final PageCursor pageCursor;
    private final PageCursorInput pageCursorInput;
    private final PagingSearchWindowAdjuster searchWindowAdjuster;
    private final List<Itinerary> itineraries;
    private PageCursorFactory pageCursorFactory = null;

    public PagingService(List<Duration> pagingSearchWindowAdjustments, Duration minSearchWindowSize, Duration maxSearchWindowSize, @Nullable Duration searchWindowUsed, @Nullable Instant earliestDepartureTime, @Nullable Instant latestArrivalTime, SortOrder itinerariesSortOrder, boolean arriveBy, int numberOfItineraries, @Nullable PageCursor pageCursor, PageCursorInput pageCursorInput, List<Itinerary> itineraries) {
        this.searchWindowUsed = searchWindowUsed;
        this.earliestDepartureTime = earliestDepartureTime;
        this.latestArrivalTime = latestArrivalTime;
        this.itinerariesSortOrder = Objects.requireNonNull(itinerariesSortOrder);
        this.arriveBy = arriveBy;
        this.numberOfItineraries = numberOfItineraries;
        this.pageCursor = pageCursor;
        this.pageCursorInput = pageCursorInput;
        this.itineraries = Objects.requireNonNull(itineraries);
        this.searchWindowAdjuster = this.createSearchWindowAdjuster(pagingSearchWindowAdjustments, minSearchWindowSize, maxSearchWindowSize);
    }

    public PageCursor nextPageCursor() {
        return this.pageCursorFactory().nextPageCursor();
    }

    public PageCursor previousPageCursor() {
        return this.pageCursorFactory().previousPageCursor();
    }

    @Nullable
    public TripSearchMetadata createTripSearchMetadata() {
        if (this.noSuccessfulTransitSearchPerformed()) {
            return null;
        }
        if (this.arriveBy) {
            return TripSearchMetadata.createForArriveBy(this.earliestDepartureTime, this.searchWindowUsed, this.firstKeptDepartureTime());
        }
        return TripSearchMetadata.createForDepartAfter(this.earliestDepartureTime, this.searchWindowUsed, this.lastKeptDepartureTime());
    }

    private Duration calculateSearchWindowNextSearch() {
        if (this.noSuccessfulTransitSearchPerformed()) {
            return null;
        }
        if (this.pageCursorInput.pageCut() != null) {
            boolean cropSWHead = this.doCropSearchWindowAtTail();
            Instant rmItineraryStartTime = this.pageCursorInput.pageCut().startTimeAsInstant();
            return this.searchWindowAdjuster.decreaseSearchWindow(this.searchWindowUsed, this.earliestDepartureTime, rmItineraryStartTime, cropSWHead);
        }
        int nFound = (int)this.itineraries.stream().filter(it -> !it.isFlaggedForDeletion() && it.hasTransit()).count();
        return this.searchWindowAdjuster.increaseOrKeepSearchWindow(this.searchWindowUsed, this.numberOfItineraries, nFound);
    }

    private Instant lastKeptDepartureTime() {
        return this.pageCursorInput.pageCut() != null ? this.pageCursorInput.pageCut().startTimeAsInstant() : null;
    }

    private Instant firstKeptDepartureTime() {
        return this.pageCursorInput.pageCut() != null ? this.pageCursorInput.pageCut().startTimeAsInstant() : null;
    }

    private PagingSearchWindowAdjuster createSearchWindowAdjuster(List<Duration> pagingSearchWindowAdjustments, Duration minSearchWindowSize, Duration maxSearchWindowSize) {
        return new PagingSearchWindowAdjuster(minSearchWindowSize, maxSearchWindowSize, pagingSearchWindowAdjustments);
    }

    private boolean doCropSearchWindowAtTail() {
        if (this.pageCursor == null) {
            return this.itinerariesSortOrder.isSortedByAscendingArrivalTime();
        }
        return this.pageCursor.type().isNext();
    }

    private PageCursorFactory pageCursorFactory() {
        if (this.pageCursorFactory == null) {
            this.pageCursorFactory = this.mapIntoPageCursorFactory(this.pageCursor == null ? null : this.pageCursor.type());
        }
        return this.pageCursorFactory;
    }

    private PageCursorFactory mapIntoPageCursorFactory(@Nullable PageType currentPageType) {
        Duration searchWindowNextSearch = this.calculateSearchWindowNextSearch();
        PageCursorFactory factory = new PageCursorFactory(this.itinerariesSortOrder, searchWindowNextSearch);
        if (this.noSuccessfulTransitSearchPerformed()) {
            return factory;
        }
        this.assertRequestPrerequisites();
        factory = factory.withOriginalSearch(currentPageType, this.itineraries.size() > 0 ? this.itineraries.get(0).startTimeAsInstant() : null, this.earliestDepartureTime, this.latestArrivalTime, this.searchWindowUsed);
        factory = factory.withPageCursorInput(this.pageCursorInput);
        return factory;
    }

    private void assertRequestPrerequisites() {
        if (this.searchWindowUsed == null) {
            throw new IllegalStateException("SearchWindow not set");
        }
        if (this.earliestDepartureTime == null) {
            throw new IllegalStateException("Earliest departure time not set");
        }
        if (this.pageCursorInput == null) {
            throw new IllegalStateException("Page cursor input not set");
        }
    }

    private boolean noSuccessfulTransitSearchPerformed() {
        return this.searchWindowUsed == null || this.earliestDepartureTime == null || this.pageCursorInput == null;
    }

    public String toString() {
        return ToStringBuilder.of(PagingService.class).addDuration("searchWindowUsed", this.searchWindowUsed).addDateTime("earliestDepartureTime", this.earliestDepartureTime).addDateTime("latestArrivalTime", this.latestArrivalTime).addEnum("itinerariesSortOrder", (Enum)this.itinerariesSortOrder).addBoolIfTrue("arriveBy", Boolean.valueOf(this.arriveBy)).addNum("numberOfItineraries", (Number)this.numberOfItineraries).addObj("pageCursor", (Object)this.pageCursor).toString();
    }
}

