/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.via.model;

import java.util.List;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.raptor.api.model.RaptorCostConverter;
import org.opentripplanner.raptor.api.model.RaptorTransfer;
import org.opentripplanner.raptor.api.model.RaptorValueFormatter;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.utils.time.DurationUtils;

public class ViaCoordinateTransfer
implements RaptorTransfer {
    private final WgsCoordinate coordinate;
    private final int fromStopIndex;
    private final int toStopIndex;
    private final List<Edge> fromEdges;
    private final List<Edge> toEdges;
    private final int durationInSeconds;
    private final int raptorCost;

    public ViaCoordinateTransfer(WgsCoordinate coordinate, int fromStopIndex, int toStopIndex, List<Edge> fromEdges, List<Edge> toEdges, int durationInSeconds, double generalizedCostInSeconds) {
        this.coordinate = coordinate;
        this.fromStopIndex = fromStopIndex;
        this.toStopIndex = toStopIndex;
        this.fromEdges = fromEdges;
        this.toEdges = toEdges;
        this.durationInSeconds = durationInSeconds;
        this.raptorCost = RaptorCostConverter.toRaptorCost((double)generalizedCostInSeconds);
    }

    public WgsCoordinate coordinate() {
        return this.coordinate;
    }

    public int fromStopIndex() {
        return this.fromStopIndex;
    }

    public List<Edge> fromEdges() {
        return this.fromEdges;
    }

    public List<Edge> toEdges() {
        return this.toEdges;
    }

    public int stop() {
        return this.toStopIndex;
    }

    public int c1() {
        return this.raptorCost;
    }

    public int durationInSeconds() {
        return this.durationInSeconds;
    }

    public String toString() {
        return "{" + String.valueOf(this.coordinate) + " " + this.fromStopIndex + " ~ " + this.toStopIndex + " " + DurationUtils.durationToStr((int)this.durationInSeconds) + " " + RaptorValueFormatter.formatC1((int)this.raptorCost) + "}";
    }
}

