/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.util;

import java.util.LinkedList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;
import org.opentripplanner.routing.util.SlopeCosts;
import org.opentripplanner.routing.util.elevation.ToblersHikingFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElevationUtils {
    private static final Logger log = LoggerFactory.getLogger(ElevationUtils.class);
    private static final double ENERGY_PER_METER_ON_FLAT = 1.0;
    private static final double ENERGY_SLOPE_FACTOR = 4000.0;
    private static final double MAX_SLOPE_WALK_EFFECTIVE_LENGTH_FACTOR = 3.0;
    private static final ToblersHikingFunction toblerWalkingFunction = new ToblersHikingFunction(3.0);
    static final double[] tx = new double[]{0.0, 0.0, 0.0, 2798.778532444275, 5000.0, 5000.0, 5000.0};
    static final double[] ty = new double[]{-0.35, -0.35, -0.35, -0.07269562783182869, -0.0024945814335295903, 0.053500304527448035, 0.12191105175593375, 0.35, 0.35, 0.35};
    static final double[] coeff = new double[]{4.3843513168660255, 3.690432372737565, 1.6791850199667697, 0.5507786695702411, 0.179777664191139, 0.08090683222276296, 0.06023930578534376, 4.678234305342381, 3.9250580214736304, 1.792458586660127, 0.5342617044172303, 0.18787442260720733, 0.07470642757615269, 0.0622018055531472, 5.313190892356879, 4.470390129912075, 2.008538138554535, 0.5461106353078401, 0.1803404295922389, 0.08145693998827369, 0.05980679595599531, 5.638489319221266, 4.773222220017663, 2.102148541223302, 0.5786289049612646, 0.16358571778476885, 0.09484618421013713, 0.05546461213343024};

    public static SlopeCosts getSlopeCosts(CoordinateSequence elev, boolean slopeLimit) {
        Coordinate[] coordinates = elev.toCoordinateArray();
        boolean flattened = false;
        double maxSlope = 0.0;
        double slopeSpeedEffectiveLength = 0.0;
        double slopeWorkCost = 0.0;
        double slopeSafetyCost = 0.0;
        double effectiveWalkLength = 0.0;
        double[] lengths = ElevationUtils.getLengthsFromElevation(elev);
        double trueLength = lengths[0];
        double flatLength = lengths[1];
        if (flatLength < 0.001) {
            return new SlopeCosts(1.0, 1.0, 0.0, 0.0, 1.0, false, 1.0);
        }
        double lengthMultiplier = trueLength / flatLength;
        for (int i = 0; i < coordinates.length - 1; ++i) {
            double run = coordinates[i + 1].x - coordinates[i].x;
            double rise = coordinates[i + 1].y - coordinates[i].y;
            if (run == 0.0) continue;
            double slope = rise / run;
            if (slopeLimit && (slope > 0.35 || slope < -0.35) || slope > 1.0 || slope < -1.0) {
                slope = 0.0;
                flattened = true;
            }
            if (maxSlope < Math.abs(slope)) {
                maxSlope = Math.abs(slope);
            }
            double slope_or_zero = Math.max(slope, 0.0);
            double hypotenuse = Math.sqrt(rise * rise + run * run);
            double energy = hypotenuse * (1.0 + 4000.0 * slope_or_zero * slope_or_zero * slope_or_zero);
            slopeWorkCost += energy;
            double slopeSpeedCoef = ElevationUtils.slopeSpeedCoefficient(slope, coordinates[i].y);
            slopeSpeedEffectiveLength += run / slopeSpeedCoef;
            double safetyCost = hypotenuse * (slopeSpeedCoef - 1.0) * 0.25;
            if (safetyCost > 0.0) {
                slopeSafetyCost += safetyCost;
            }
            effectiveWalkLength += ElevationUtils.calculateEffectiveWalkLength(run, rise);
        }
        return new SlopeCosts(slopeSpeedEffectiveLength / flatLength, slopeWorkCost / flatLength, slopeSafetyCost, maxSlope, lengthMultiplier, flattened, effectiveWalkLength / flatLength);
    }

    public static double slopeSpeedCoefficient(double slope, double altitude) {
        int i1;
        double f;
        int lj;
        int li;
        int i;
        int j;
        int nx = 7;
        int ny = 10;
        int kx = 2;
        int ky = 2;
        double[] h = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] hh = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] w_x = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] w_y = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        int kx1 = kx + 1;
        int nkx1 = nx - kx1;
        int l = kx1;
        int l1 = l + 1;
        while (altitude >= tx[l1 - 1] && l != nkx1) {
            l = l1;
            l1 = l + 1;
        }
        h[0] = 1.0;
        for (j = 1; j < kx + 1; ++j) {
            for (i = 0; i < j; ++i) {
                hh[i] = h[i];
            }
            h[0] = 0.0;
            for (i = 0; i < j; ++i) {
                li = l + i;
                lj = li - j;
                if (tx[li] != tx[lj]) {
                    f = hh[i] / (tx[li] - tx[lj]);
                    h[i] = h[i] + f * (tx[li] - altitude);
                    h[i + 1] = f * (altitude - tx[lj]);
                    continue;
                }
                h[i + 1 - 1] = 0.0;
            }
        }
        int lx = l - kx1;
        for (j = 0; j < kx1; ++j) {
            w_x[j] = h[j];
        }
        int ky1 = ky + 1;
        int nky1 = ny - ky1;
        l = ky1;
        l1 = l + 1;
        while (slope >= ty[l1 - 1] && l != nky1) {
            l = l1;
            l1 = l + 1;
        }
        h[0] = 1.0;
        for (j = 1; j < ky + 1; ++j) {
            for (i = 0; i < j; ++i) {
                hh[i] = h[i];
            }
            h[0] = 0.0;
            for (i = 0; i < j; ++i) {
                li = l + i;
                lj = li - j;
                if (ty[li] != ty[lj]) {
                    f = hh[i] / (ty[li] - ty[lj]);
                    h[i] = h[i] + f * (ty[li] - slope);
                    h[i + 1] = f * (slope - ty[lj]);
                    continue;
                }
                h[i + 1 - 1] = 0.0;
            }
        }
        int ly = l - ky1;
        for (j = 0; j < ky1; ++j) {
            w_y[j] = h[j];
        }
        l = lx * nky1;
        for (i1 = 0; i1 < kx1; ++i1) {
            h[i1] = w_x[i1];
        }
        l1 = l + ly;
        double temp = 0.0;
        for (i1 = 0; i1 < kx1; ++i1) {
            int l2 = l1;
            for (int j1 = 0; j1 < ky1; ++j1) {
                temp += coeff[++l2 - 1] * h[i1] * w_y[j1];
            }
            l1 += nky1;
        }
        return temp;
    }

    public static PackedCoordinateSequence getPartialElevationProfile(PackedCoordinateSequence elevationProfile, double start, double end) {
        if (elevationProfile == null) {
            return null;
        }
        if (start < 0.0) {
            start = 0.0;
        }
        Coordinate[] coordinateArray = elevationProfile.toCoordinateArray();
        double length = coordinateArray[coordinateArray.length - 1].x;
        if (end > length) {
            end = length;
        }
        double newLength = end - start;
        boolean started = false;
        Coordinate lastCoord = null;
        LinkedList<Coordinate> coordList = new LinkedList<Coordinate>();
        for (Coordinate coord : coordinateArray) {
            double rise;
            double p;
            double run;
            if (coord.x >= start && !started) {
                started = true;
                if (lastCoord != null) {
                    run = coord.x - lastCoord.x;
                    p = (start - lastCoord.x) / run;
                    rise = coord.y - lastCoord.y;
                    double newX = lastCoord.x + p * run - start;
                    double newY = lastCoord.y + p * rise;
                    if (p > 0.0 && p < 1.0) {
                        coordList.add(new Coordinate(newX, newY));
                    }
                }
            }
            if (started && coord.x >= start && coord.x <= end) {
                coordList.add(new Coordinate(coord.x - start, coord.y));
            }
            if (started && coord.x >= end) {
                if (lastCoord == null || !(lastCoord.x < end) || !(coord.x > end)) break;
                run = coord.x - lastCoord.x;
                p = (end - lastCoord.x) / run;
                rise = coord.y - lastCoord.y;
                double newY = lastCoord.y + p * rise;
                coordList.add(new Coordinate(newLength, newY));
                break;
            }
            lastCoord = coord;
        }
        if (coordList.size() < 2) {
            return null;
        }
        Coordinate[] coordArr = new Coordinate[coordList.size()];
        return new PackedCoordinateSequence.Float(coordList.toArray(coordArr), 2);
    }

    public static Double parseEleTag(String ele) {
        ele = ele.toLowerCase();
        double unit = 1.0;
        if (ele.endsWith("m")) {
            ele = ele.replaceFirst("\\s*m", "");
        } else if (ele.endsWith("ft")) {
            ele = ele.replaceFirst("\\s*ft", "");
            unit = 0.3048;
        }
        try {
            return Double.parseDouble(ele) * unit;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static double calculateEffectiveWalkLength(double run, double rise) {
        return run * toblerWalkingFunction.calculateHorizontalWalkingDistanceMultiplier(run, rise);
    }

    private static double[] getLengthsFromElevation(CoordinateSequence elev) {
        double trueLength = 0.0;
        double flatLength = 0.0;
        double lastX = elev.getX(0);
        double lastY = elev.getY(0);
        for (int i = 1; i < elev.size(); ++i) {
            Coordinate c = elev.getCoordinate(i);
            double x = c.x - lastX;
            double y = c.y - lastY;
            trueLength += Math.sqrt(x * x + y * y);
            flatLength += x;
            lastX = c.x;
            lastY = c.y;
        }
        return new double[]{trueLength, flatLength};
    }
}

