/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.services.notes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opentripplanner.routing.services.notes.StreetNoteModel;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.note.StreetNote;
import org.opentripplanner.street.model.note.StreetNoteAndMatcher;
import org.opentripplanner.street.model.note.StreetNoteMatcher;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.state.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreetNotesService
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(StreetNotesService.class);
    public static final StreetNoteMatcher WHEELCHAIR_MATCHER = new StreetNoteMatcher(){

        @Override
        public boolean matches(State state) {
            return state.getRequest().wheelchair();
        }
    };
    public static final StreetNoteMatcher DRIVING_MATCHER = new StreetNoteMatcher(){

        @Override
        public boolean matches(State state) {
            return state.getBackMode().isInCar();
        }
    };
    public static final StreetNoteMatcher BICYCLE_MATCHER = new StreetNoteMatcher(){

        @Override
        public boolean matches(State state) {
            return state.getBackMode() == TraverseMode.BICYCLE;
        }
    };
    public static final StreetNoteMatcher ALWAYS_MATCHER = new StreetNoteMatcher(){

        @Override
        public boolean matches(State state) {
            return true;
        }
    };
    private final List<StreetNoteModel> sources = new ArrayList<StreetNoteModel>();
    private final StreetNoteModel staticNotesSource = new StreetNoteModel();

    public StreetNotesService() {
        this.sources.add(this.staticNotesSource);
    }

    public void addNotesSource(StreetNoteModel source) {
        this.sources.add(source);
    }

    public Set<StreetNote> getNotes(State state) {
        Edge edge = state.getBackEdge();
        HashSet<StreetNoteAndMatcher> maas = new HashSet<StreetNoteAndMatcher>();
        for (StreetNoteModel source : this.sources) {
            Set<StreetNoteAndMatcher> maas2 = source.getNotes(edge);
            if (maas2 == null) continue;
            maas.addAll(maas2);
        }
        if (maas == null || maas.isEmpty()) {
            return Set.of();
        }
        HashSet<StreetNote> notes = new HashSet<StreetNote>(maas.size());
        for (StreetNoteAndMatcher maa : maas) {
            if (!maa.matcher().matches(state)) continue;
            notes.add(maa.note());
        }
        if (notes.isEmpty()) {
            return Set.of();
        }
        return notes;
    }

    public void addStaticNote(Edge edge, StreetNote note, StreetNoteMatcher matcher) {
        this.staticNotesSource.addNote(edge, note, matcher);
    }

    public void removeStaticNotes(Edge edge) {
        this.staticNotesSource.removeNotes(edge);
    }
}

