/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.services.notes;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.TemporaryPartialStreetEdge;
import org.opentripplanner.street.model.note.StreetNote;
import org.opentripplanner.street.model.note.StreetNoteAndMatcher;
import org.opentripplanner.street.model.note.StreetNoteMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreetNoteModel
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(StreetNoteModel.class);
    private final SetMultimap<Edge, StreetNoteAndMatcher> notesForEdge = HashMultimap.create();
    private final transient Map<StreetNoteAndMatcher, StreetNoteAndMatcher> uniqueMatchers = new HashMap<StreetNoteAndMatcher, StreetNoteAndMatcher>();

    StreetNoteModel() {
    }

    public Set<StreetNoteAndMatcher> getNotes(Edge edge) {
        Set maas;
        if (edge instanceof TemporaryPartialStreetEdge) {
            edge = ((TemporaryPartialStreetEdge)edge).getParentEdge();
        }
        if ((maas = this.notesForEdge.get((Object)edge)) == null || maas.isEmpty()) {
            return null;
        }
        return maas;
    }

    void addNote(Edge edge, StreetNote note, StreetNoteMatcher matcher) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding note {} to {} with matcher {}", new Object[]{note, edge, matcher});
        }
        this.notesForEdge.put((Object)edge, (Object)this.buildMatcherAndAlert(matcher, note));
    }

    void removeNotes(Edge edge) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing notes for edge: {}", (Object)edge);
        }
        this.notesForEdge.removeAll((Object)edge);
    }

    private StreetNoteAndMatcher buildMatcherAndAlert(StreetNoteMatcher noteMatcher, StreetNote note) {
        StreetNoteAndMatcher candidate = new StreetNoteAndMatcher(note, noteMatcher);
        StreetNoteAndMatcher interned = this.uniqueMatchers.putIfAbsent(candidate, candidate);
        return interned == null ? candidate : interned;
    }
}

