/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.service;

import java.time.ZoneId;
import org.opentripplanner.framework.application.OTPRequestTimeoutException;
import org.opentripplanner.framework.time.ZoneIdFallback;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.RoutingWorker;
import org.opentripplanner.routing.algorithm.via.ViaRoutingWorker;
import org.opentripplanner.routing.api.RoutingService;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.RouteViaRequest;
import org.opentripplanner.routing.api.response.RoutingResponse;
import org.opentripplanner.routing.api.response.TripSearchMetadata;
import org.opentripplanner.routing.api.response.ViaRoutingResponse;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.utils.tostring.MultiLineToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRoutingService
implements RoutingService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRoutingService.class);
    private final OtpServerRequestContext serverContext;
    private final ZoneId timeZone;

    public DefaultRoutingService(OtpServerRequestContext serverContext) {
        this.serverContext = serverContext;
        this.timeZone = ZoneIdFallback.zoneId(serverContext.transitService().getTimeZone());
    }

    @Override
    public RoutingResponse route(RouteRequest request) {
        LOG.debug("Request: {}", (Object)request);
        OTPRequestTimeoutException.checkForTimeout();
        request.validateOriginAndDestination();
        RoutingWorker worker = new RoutingWorker(this.serverContext, request, this.timeZone);
        RoutingResponse response = worker.route();
        this.logResponse(response);
        return response;
    }

    @Override
    public ViaRoutingResponse route(RouteViaRequest request) {
        LOG.debug("Request: {}", (Object)request);
        OTPRequestTimeoutException.checkForTimeout();
        ViaRoutingWorker viaRoutingWorker = new ViaRoutingWorker(request, req -> new RoutingWorker(this.serverContext, (RouteRequest)req, this.serverContext.transitService().getTimeZone()).route());
        return viaRoutingWorker.route();
    }

    private void logResponse(RoutingResponse response) {
        if (response.getTripPlan().itineraries.isEmpty() && response.getRoutingErrors().isEmpty()) {
            LOG.warn("The routing result is empty, but there is no errors...");
        }
        if (LOG.isDebugEnabled()) {
            TripSearchMetadata m = response.getMetadata();
            String text = MultiLineToStringBuilder.of((String)"Response").addDuration("SearchWindowUsed", m == null ? null : m.searchWindowUsed).add("NextPage", (Object)response.getNextPageCursor()).add("PreviousPage", (Object)response.getPreviousPageCursor()).addColNl("Itineraries", response.getTripPlan().itineraries.stream().map(Itinerary::toStr).toList()).addColNl("Errors", response.getRoutingErrors()).toString();
            LOG.debug(text);
        }
    }
}

