/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.opentripplanner.routing.alertpatch.EntityKey;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.StopCondition;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Direction;
import org.opentripplanner.transit.service.TimetableRepository;

public class TransitAlertServiceImpl
implements TransitAlertService {
    private final TimetableRepository timetableRepository;
    private Multimap<EntityKey, TransitAlert> alerts = HashMultimap.create();

    public TransitAlertServiceImpl(TimetableRepository timetableRepository) {
        this.timetableRepository = timetableRepository;
    }

    @Override
    public void setAlerts(Collection<TransitAlert> alerts) {
        HashMultimap newAlerts = HashMultimap.create();
        for (TransitAlert alert : alerts) {
            for (EntitySelector entity : alert.entities()) {
                newAlerts.put((Object)entity.key(), (Object)alert);
            }
        }
        this.alerts = newAlerts;
    }

    @Override
    public Collection<TransitAlert> getAllAlerts() {
        return new HashSet<TransitAlert>(this.alerts.values());
    }

    @Override
    public TransitAlert getAlertById(FeedScopedId id) {
        return this.alerts.values().stream().filter(transitAlert -> transitAlert.getId().equals(id)).findAny().orElse(null);
    }

    @Override
    public Collection<TransitAlert> getStopAlerts(FeedScopedId stopId, Set<StopCondition> stopConditions) {
        EntitySelector.Stop entitySelector = new EntitySelector.Stop(stopId, stopConditions);
        Collection<TransitAlert> result = this.findMatchingAlerts(entitySelector);
        StopLocation stop = this.timetableRepository.getSiteRepository().getStopLocation(stopId);
        if (stop != null && stop.isPartOfStation()) {
            result.addAll(this.findMatchingAlerts(new EntitySelector.Stop(Objects.requireNonNull(stop.getParentStation()).getId(), stopConditions)));
        }
        return result;
    }

    @Override
    public Collection<TransitAlert> getRouteAlerts(FeedScopedId route) {
        return this.alerts.get((Object)new EntityKey.Route(route));
    }

    @Override
    public Collection<TransitAlert> getTripAlerts(FeedScopedId trip) {
        return this.findMatchingAlerts(new EntitySelector.Trip(trip));
    }

    @Override
    public Collection<TransitAlert> getTripAlerts(FeedScopedId trip, LocalDate serviceDate) {
        return this.findMatchingAlerts(new EntitySelector.Trip(trip, serviceDate));
    }

    @Override
    public Collection<TransitAlert> getAgencyAlerts(FeedScopedId agency) {
        return this.alerts.get((Object)new EntityKey.Agency(agency));
    }

    @Override
    public Collection<TransitAlert> getStopAndRouteAlerts(FeedScopedId stop, FeedScopedId route, Set<StopCondition> stopConditions) {
        EntitySelector.StopAndRoute entitySelector = new EntitySelector.StopAndRoute(stop, route, stopConditions);
        return this.findMatchingAlerts(entitySelector);
    }

    @Override
    public Collection<TransitAlert> getStopAndTripAlerts(FeedScopedId stop, FeedScopedId trip, LocalDate serviceDate, Set<StopCondition> stopConditions) {
        EntitySelector.StopAndTrip entitySelector = new EntitySelector.StopAndTrip(stop, trip, serviceDate, stopConditions);
        return this.findMatchingAlerts(entitySelector);
    }

    @Override
    public Collection<TransitAlert> getRouteTypeAndAgencyAlerts(int routeType, FeedScopedId agency) {
        return this.alerts.get((Object)new EntityKey.RouteTypeAndAgency(agency, routeType));
    }

    @Override
    public Collection<TransitAlert> getRouteTypeAlerts(int routeType, String feedId) {
        return this.alerts.get((Object)new EntityKey.RouteType(feedId, routeType));
    }

    @Override
    public Collection<TransitAlert> getDirectionAndRouteAlerts(Direction direction, FeedScopedId route) {
        return this.alerts.get((Object)new EntityKey.DirectionAndRoute(route, direction));
    }

    private Collection<TransitAlert> findMatchingAlerts(EntitySelector entitySelector) {
        HashSet<TransitAlert> result = new HashSet<TransitAlert>();
        for (TransitAlert alert : this.alerts.get((Object)entitySelector.key())) {
            if (!alert.entities().stream().anyMatch(selector -> selector.matches(entitySelector))) continue;
            result.add(alert);
        }
        return result;
    }
}

