/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.impl;

import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.opentripplanner.astar.model.GraphPath;
import org.opentripplanner.astar.spi.TraverseVisitor;
import org.opentripplanner.astar.strategy.DurationSkipEdgeStrategy;
import org.opentripplanner.astar.strategy.PathComparator;
import org.opentripplanner.ext.dataoverlay.routing.DataOverlayContext;
import org.opentripplanner.framework.application.OTPRequestTimeoutException;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.preference.StreetPreferences;
import org.opentripplanner.routing.error.PathNotFoundException;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.StreetSearchBuilder;
import org.opentripplanner.street.search.TemporaryVerticesContainer;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.strategy.DominanceFunctions;
import org.opentripplanner.street.search.strategy.EuclideanRemainingWeightHeuristic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphPathFinder {
    private static final Logger LOG = LoggerFactory.getLogger(GraphPathFinder.class);
    @Nullable
    private final TraverseVisitor<State, Edge> traverseVisitor;
    private final DataOverlayContext dataOverlayContext;
    private final float maxCarSpeed;

    public GraphPathFinder(@Nullable TraverseVisitor<State, Edge> traverseVisitor) {
        this(traverseVisitor, null, 40.0f);
    }

    public GraphPathFinder(@Nullable TraverseVisitor<State, Edge> traverseVisitor, @Nullable DataOverlayContext dataOverlayContext, float maxCarSpeed) {
        this.traverseVisitor = traverseVisitor;
        this.dataOverlayContext = dataOverlayContext;
        this.maxCarSpeed = maxCarSpeed;
    }

    public List<GraphPath<State, Edge, Vertex>> getPaths(RouteRequest request, Set<Vertex> from, Set<Vertex> to) {
        StreetPreferences preferences = request.preferences().street();
        StreetSearchBuilder aStar = ((StreetSearchBuilder)((StreetSearchBuilder)((StreetSearchBuilder)((StreetSearchBuilder)((StreetSearchBuilder)StreetSearchBuilder.of().setHeuristic(new EuclideanRemainingWeightHeuristic(Float.valueOf(this.maxCarSpeed)))).setSkipEdgeStrategy(new DurationSkipEdgeStrategy(preferences.maxDirectDuration().valueOf(request.journey().direct().mode())))).setDominanceFunction(new DominanceFunctions.MinimumWeight())).setRequest(request).setStreetRequest(request.journey().direct()).setFrom(from)).setTo(to)).setDataOverlayContext(this.dataOverlayContext);
        if (this.traverseVisitor != null) {
            aStar.setTraverseVisitor(this.traverseVisitor);
        }
        LOG.debug("rreq={}", (Object)request);
        long searchBeginTime = System.currentTimeMillis();
        LOG.debug("BEGIN SEARCH");
        List<GraphPath<State, Edge, Vertex>> paths = aStar.getPathsToTarget();
        LOG.debug("we have {} paths", (Object)paths.size());
        LOG.debug("END SEARCH ({} msec)", (Object)(System.currentTimeMillis() - searchBeginTime));
        paths.sort(new PathComparator(request.arriveBy()));
        return paths;
    }

    public List<GraphPath<State, Edge, Vertex>> graphPathFinderEntryPoint(RouteRequest request, TemporaryVerticesContainer vertexContainer) {
        return this.graphPathFinderEntryPoint(request, vertexContainer.getFromVertices(), vertexContainer.getToVertices());
    }

    public List<GraphPath<State, Edge, Vertex>> graphPathFinderEntryPoint(RouteRequest request, Set<Vertex> from, Set<Vertex> to) {
        OTPRequestTimeoutException.checkForTimeout();
        Instant reqTime = request.dateTime() == null ? RouteRequest.normalizeNow() : request.dateTime();
        List<GraphPath<State, Edge, Vertex>> paths = this.getPaths(request, from, to);
        if (paths != null) {
            Iterator<GraphPath<State, Edge, Vertex>> gpi = paths.iterator();
            while (gpi.hasNext()) {
                GraphPath<State, Edge, Vertex> graphPath = gpi.next();
                if (request.arriveBy()) {
                    if (!((State)graphPath.states.getLast()).getTimeAccurate().isAfter(reqTime)) continue;
                    LOG.error("A graph path arrives {} after the requested time {}. This implies a bug.", (Object)((State)graphPath.states.getLast()).getTimeAccurate(), (Object)reqTime);
                    gpi.remove();
                    continue;
                }
                if (!((State)graphPath.states.getFirst()).getTimeAccurate().isBefore(reqTime)) continue;
                LOG.error("A graph path leaves {} before the requested time {}. This implies a bug.", (Object)((State)graphPath.states.getFirst()).getTimeAccurate(), (Object)reqTime);
                gpi.remove();
            }
        }
        if (paths == null || paths.isEmpty()) {
            LOG.debug("Path not found: {} : {}", (Object)request.from(), (Object)request.to());
            throw new PathNotFoundException();
        }
        return paths;
    }
}

