/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graphfinder;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.astar.spi.SkipEdgeStrategy;
import org.opentripplanner.astar.spi.TraverseVisitor;
import org.opentripplanner.model.GenericLocation;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graphfinder.GraphFinder;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.routing.graphfinder.PlaceAtDistance;
import org.opentripplanner.routing.graphfinder.PlaceFinderTraverseVisitor;
import org.opentripplanner.routing.graphfinder.PlaceType;
import org.opentripplanner.routing.graphfinder.StopFinderTraverseVisitor;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.search.StreetSearchBuilder;
import org.opentripplanner.street.search.TemporaryVerticesContainer;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.strategy.DominanceFunctions;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.service.TransitService;

public class StreetGraphFinder
implements GraphFinder {
    private final Graph graph;
    private final VertexLinker linker;

    public StreetGraphFinder(Graph graph, VertexLinker linker) {
        this.graph = graph;
        this.linker = linker;
    }

    @Override
    public List<NearbyStop> findClosestStops(Coordinate coordinate, double radiusMeters) {
        StopFinderTraverseVisitor visitor = new StopFinderTraverseVisitor(radiusMeters);
        this.findClosestUsingStreets(coordinate.getY(), coordinate.getX(), visitor, visitor.getSkipEdgeStrategy());
        return visitor.stopsFound();
    }

    @Override
    public List<PlaceAtDistance> findClosestPlaces(double lat, double lon, double radiusMeters, int maxResults, List<TransitMode> filterByModes, List<PlaceType> filterByPlaceTypes, List<FeedScopedId> filterByStops, List<FeedScopedId> filterByStations, List<FeedScopedId> filterByRoutes, List<String> filterByBikeRentalStations, List<String> filterByNetwork, TransitService transitService) {
        PlaceFinderTraverseVisitor visitor = new PlaceFinderTraverseVisitor(transitService, filterByModes, filterByPlaceTypes, filterByStops, filterByStations, filterByRoutes, filterByBikeRentalStations, filterByNetwork, maxResults, radiusMeters);
        SkipEdgeStrategy<State, Edge> terminationStrategy = visitor.getSkipEdgeStrategy();
        this.findClosestUsingStreets(lat, lon, visitor, terminationStrategy);
        List<PlaceAtDistance> results = visitor.placesFound;
        results.sort(Comparator.comparingDouble(PlaceAtDistance::distance));
        return results.subList(0, Integer.min(results.size(), maxResults));
    }

    private void findClosestUsingStreets(double lat, double lon, TraverseVisitor<State, Edge> visitor, SkipEdgeStrategy<State, Edge> skipEdgeStrategy) {
        RouteRequest request = RouteRequest.of().withPreferences(pref -> pref.withWalk(it -> it.withSpeed(1.0))).withNumItineraries(1).buildDefault();
        try (TemporaryVerticesContainer temporaryVertices = new TemporaryVerticesContainer(this.graph, this.linker, id -> Set.of(), GenericLocation.fromCoordinate(lat, lon), GenericLocation.UNKNOWN, StreetMode.WALK, StreetMode.WALK);){
            ((StreetSearchBuilder)((StreetSearchBuilder)((StreetSearchBuilder)StreetSearchBuilder.of().setSkipEdgeStrategy(skipEdgeStrategy)).setTraverseVisitor(visitor)).setDominanceFunction(new DominanceFunctions.LeastWalk())).setRequest(request).setVerticesContainer(temporaryVertices).getShortestPathTree();
        }
    }
}

