/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graphfinder;

import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.astar.spi.SkipEdgeStrategy;
import org.opentripplanner.astar.spi.TraverseVisitor;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.utils.collection.ListUtils;

public class StopFinderTraverseVisitor
implements TraverseVisitor<State, Edge> {
    private final double radiusMeters;
    private final List<NearbyStop> stopsFound = new ArrayList<NearbyStop>();

    public StopFinderTraverseVisitor(double radiusMeters) {
        this.radiusMeters = radiusMeters;
    }

    @Override
    public void visitEdge(Edge edge) {
    }

    @Override
    public void visitVertex(State state) {
        Vertex vertex = state.getVertex();
        if (vertex instanceof TransitStopVertex) {
            TransitStopVertex tsv = (TransitStopVertex)vertex;
            this.stopsFound.add(NearbyStop.nearbyStopForState(state, tsv.getStop()));
        }
    }

    @Override
    public void visitEnqueue() {
    }

    public List<NearbyStop> stopsFound() {
        return ListUtils.distinctByKey(this.stopsFound, ns -> ns.stop);
    }

    public SkipEdgeStrategy<State, Edge> getSkipEdgeStrategy() {
        return (current, edge) -> current.getWalkDistance() > this.radiusMeters;
    }
}

