/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graphfinder;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.service.ArrivalDeparture;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class PatternAtStop {
    public String id;
    public StopLocation stop;
    public TripPattern pattern;

    public PatternAtStop(StopLocation stop, TripPattern pattern) {
        this.id = PatternAtStop.toId(stop, pattern);
        this.stop = stop;
        this.pattern = pattern;
    }

    public static PatternAtStop fromId(TransitService transitService, String id) {
        String[] parts = id.split(";", 2);
        Base64.Decoder decoder = Base64.getDecoder();
        FeedScopedId stopId = FeedScopedId.parse(new String(decoder.decode(parts[0]), StandardCharsets.UTF_8));
        FeedScopedId patternId = FeedScopedId.parse(new String(decoder.decode(parts[1]), StandardCharsets.UTF_8));
        return new PatternAtStop(transitService.getRegularStop(stopId), transitService.getTripPattern(patternId));
    }

    public List<TripTimeOnDate> getStoptimes(TransitService transitService, Instant startTime, Duration timeRange, int numberOfDepartures, ArrivalDeparture arrivalDeparture) {
        return transitService.findTripTimesOnDate(this.stop, this.pattern, startTime, timeRange, numberOfDepartures, arrivalDeparture, true);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.stop, this.pattern);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternAtStop that = (PatternAtStop)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.stop, that.stop) && Objects.equals(this.pattern, that.pattern);
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addStr("id", this.id).addObj("stop", (Object)this.stop).addObj("pattern", (Object)this.pattern).toString();
    }

    private static String toId(StopLocation stop, TripPattern pattern) {
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(stop.getId().toString().getBytes(StandardCharsets.UTF_8)) + ";" + encoder.encodeToString(pattern.getId().toString().getBytes(StandardCharsets.UTF_8));
    }
}

