/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graphfinder;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.astar.model.GraphPath;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.request.StreetRequest;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.request.StreetSearchRequest;
import org.opentripplanner.street.search.request.StreetSearchRequestMapper;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.transit.model.site.StopLocation;

public class NearbyStop
implements Comparable<NearbyStop> {
    public final StopLocation stop;
    public final double distance;
    public final List<Edge> edges;
    public final State state;

    public NearbyStop(StopLocation stop, double distance, List<Edge> edges, State state) {
        this.stop = stop;
        this.distance = distance;
        this.edges = edges;
        this.state = state;
    }

    public static NearbyStop nearbyStopForState(State state, StopLocation stop) {
        double effectiveWalkDistance = 0.0;
        GraphPath graphPath = new GraphPath(state);
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Edge edge : graphPath.edges) {
            effectiveWalkDistance += edge.getEffectiveWalkDistance();
            edges.add(edge);
        }
        return new NearbyStop(stop, effectiveWalkDistance, edges, state);
    }

    public static NearbyStop ofZeroDistance(StopLocation stop, State state) {
        return new NearbyStop(stop, 0.0, Collections.emptyList(), state);
    }

    public static List<NearbyStop> nearbyStopsForTransitStopVertices(Set<TransitStopVertex> stopVertices, boolean reverseDirection, RouteRequest routeRequest, StreetRequest streetRequest) {
        if (stopVertices.isEmpty()) {
            return List.of();
        }
        StreetSearchRequest streetSearchRequest = StreetSearchRequestMapper.mapToTransferRequest(routeRequest).withArriveBy(reverseDirection).withMode(streetRequest.mode()).build();
        return stopVertices.stream().map(s -> NearbyStop.ofZeroDistance(s.getStop(), new State((Vertex)s, streetSearchRequest))).toList();
    }

    public static List<NearbyStop> nearbyStopsForTransitStopVerticesFiltered(Collection<? extends Vertex> vertices, boolean reverseDirection, RouteRequest routeRequest, StreetRequest streetRequest) {
        Set<TransitStopVertex> transitStops = vertices.stream().filter(v -> v instanceof TransitStopVertex).map(v -> (TransitStopVertex)v).collect(Collectors.toSet());
        return NearbyStop.nearbyStopsForTransitStopVertices(transitStops, reverseDirection, routeRequest, streetRequest);
    }

    public boolean isBetter(NearbyStop other) {
        return this.compareTo(other) < 0;
    }

    @Override
    public int compareTo(NearbyStop that) {
        if (this.state == null != (that.state == null)) {
            throw new IllegalStateException("Only NearbyStops which both contain or lack a state may be compared.");
        }
        if (this.state != null) {
            return (int)this.state.getWeight() - (int)that.state.getWeight();
        }
        return (int)this.distance - (int)that.distance;
    }

    public Duration duration() {
        return Duration.ofSeconds(this.state.getElapsedTimeSeconds());
    }

    public int hashCode() {
        return Objects.hash(this.stop, this.distance, this.edges, this.state);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NearbyStop that = (NearbyStop)o;
        return Double.compare(that.distance, this.distance) == 0 && this.stop.equals(that.stop) && Objects.equals(this.edges, that.edges) && Objects.equals(this.state, that.state);
    }

    public String toString() {
        return String.format(Locale.ROOT, "stop %s at %.1f meters%s%s", this.stop, this.distance, this.edges != null ? " (" + this.edges.size() + " edges)" : "", this.state != null ? " w/state" : "");
    }
}

