/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graphfinder;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graphfinder.DirectGraphFinder;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.routing.graphfinder.PlaceAtDistance;
import org.opentripplanner.routing.graphfinder.PlaceType;
import org.opentripplanner.routing.graphfinder.StreetGraphFinder;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.service.TransitService;

public interface GraphFinder {
    public static GraphFinder getInstance(Graph graph, VertexLinker linker, Function<Envelope, Collection<RegularStop>> queryNearbyStops) {
        return graph.hasStreets ? new StreetGraphFinder(graph, linker) : new DirectGraphFinder(queryNearbyStops);
    }

    public List<NearbyStop> findClosestStops(Coordinate var1, double var2);

    public List<PlaceAtDistance> findClosestPlaces(double var1, double var3, double var5, int var7, List<TransitMode> var8, List<PlaceType> var9, List<FeedScopedId> var10, List<FeedScopedId> var11, List<FeedScopedId> var12, List<String> var13, List<String> var14, TransitService var15);
}

