/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graphfinder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.framework.geometry.SphericalDistanceLibrary;
import org.opentripplanner.routing.graphfinder.GraphFinder;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.routing.graphfinder.PlaceAtDistance;
import org.opentripplanner.routing.graphfinder.PlaceType;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.service.TransitService;

public class DirectGraphFinder
implements GraphFinder {
    private final Function<Envelope, Collection<RegularStop>> queryNearbyStops;

    public DirectGraphFinder(Function<Envelope, Collection<RegularStop>> queryNearbyStops) {
        this.queryNearbyStops = queryNearbyStops;
    }

    @Override
    public List<NearbyStop> findClosestStops(Coordinate coordinate, double radiusMeters) {
        ArrayList<NearbyStop> stopsFound = new ArrayList<NearbyStop>();
        Envelope envelope = new Envelope(coordinate);
        envelope.expandBy(SphericalDistanceLibrary.metersToLonDegrees(radiusMeters, coordinate.y), SphericalDistanceLibrary.metersToDegrees(radiusMeters));
        for (RegularStop it : this.queryNearbyStops.apply(envelope)) {
            double distance = Math.round(SphericalDistanceLibrary.distance(coordinate, it.getCoordinate().asJtsCoordinate()));
            if (!(distance < radiusMeters)) continue;
            NearbyStop sd = new NearbyStop(it, distance, null, null);
            stopsFound.add(sd);
        }
        stopsFound.sort(NearbyStop::compareTo);
        return stopsFound;
    }

    @Override
    public List<PlaceAtDistance> findClosestPlaces(double lat, double lon, double maxDistance, int maxResults, List<TransitMode> filterByModes, List<PlaceType> filterByPlaceTypes, List<FeedScopedId> filterByStops, List<FeedScopedId> filterByStations, List<FeedScopedId> filterByRoutes, List<String> filterByBikeRentalStations, List<String> filterByNetwork, TransitService transitService) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

