/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graph;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.geometry.HashGridSpatialIndex;
import org.opentripplanner.routing.graph.EdgeSpatialIndex;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.linking.Scope;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.StationCentroidVertex;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.utils.logging.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StreetIndex {
    private static final Logger LOG = LoggerFactory.getLogger(StreetIndex.class);
    private final Map<FeedScopedId, TransitStopVertex> stopVertices;
    private final Map<FeedScopedId, StationCentroidVertex> stationCentroidVertices;
    private final EdgeSpatialIndex edgeIndex = new EdgeSpatialIndex();
    private final HashGridSpatialIndex<Vertex> vertexIndex = new HashGridSpatialIndex();

    StreetIndex(Graph graph) {
        this.stopVertices = StreetIndex.indexStopIds(graph);
        this.stationCentroidVertices = StreetIndex.indexStationCentroids(graph);
        this.postSetup(graph.getVertices());
    }

    Optional<TransitStopVertex> findStopVertex(FeedScopedId id) {
        return Optional.ofNullable(this.stopVertices.get(id));
    }

    Optional<StationCentroidVertex> findStationCentroidVertex(FeedScopedId id) {
        return Optional.ofNullable(this.stationCentroidVertices.get(id));
    }

    List<Vertex> findVertices(Envelope envelope) {
        List<Vertex> vertices = this.vertexIndex.query(envelope);
        vertices.removeIf(v -> !envelope.contains(new Coordinate(v.getLon(), v.getLat())));
        return vertices;
    }

    Collection<Edge> findEdges(Envelope envelope) {
        return this.edgeIndex.query(envelope, Scope.PERMANENT).filter(e -> e.isReachableFromGraph() && envelope.intersects(StreetIndex.edgeGeometryOrStraightLine(e).getEnvelopeInternal())).toList();
    }

    Collection<Edge> findEdges(Envelope env, Scope scope) {
        return this.edgeIndex.query(env, scope).toList();
    }

    void insert(Edge edge, Scope scope) {
        this.edgeIndex.insert(edge, scope);
    }

    void remove(Edge e, Scope scope) {
        this.edgeIndex.remove(e, scope);
    }

    void remove(Vertex vertex) {
        this.vertexIndex.remove(new Envelope(vertex.getCoordinate()), vertex);
    }

    private static LineString edgeGeometryOrStraightLine(Edge e) {
        LineString geometry = e.getGeometry();
        if (geometry == null) {
            Coordinate[] coordinates = new Coordinate[]{e.getFromVertex().getCoordinate(), e.getToVertex().getCoordinate()};
            geometry = GeometryUtils.getGeometryFactory().createLineString(coordinates);
        }
        return geometry;
    }

    private void postSetup(Collection<Vertex> vertices) {
        ProgressTracker progress = ProgressTracker.track((String)"Index street vertex", (int)1000, (long)vertices.size());
        LOG.info(progress.startMessage());
        for (Vertex gv : vertices) {
            for (Edge e : gv.getOutgoing()) {
                LineString geometry = StreetIndex.edgeGeometryOrStraightLine(e);
                this.edgeIndex.insert(geometry, e, Scope.PERMANENT);
            }
            Envelope env = new Envelope(gv.getCoordinate());
            this.vertexIndex.insert(env, (Object)gv);
            progress.step(m -> LOG.info(m));
        }
        this.edgeIndex.compact();
        this.vertexIndex.compact();
        LOG.info(progress.completeMessage());
    }

    private static Map<FeedScopedId, TransitStopVertex> indexStopIds(Graph graph) {
        List<TransitStopVertex> vertices = graph.getVerticesOfType(TransitStopVertex.class);
        HashMap<FeedScopedId, TransitStopVertex> map = new HashMap<FeedScopedId, TransitStopVertex>();
        for (TransitStopVertex it : vertices) {
            map.put(it.getStop().getId(), it);
        }
        return Map.copyOf(map);
    }

    private static Map<FeedScopedId, StationCentroidVertex> indexStationCentroids(Graph graph) {
        return graph.getVerticesOfType(StationCentroidVertex.class).stream().filter(vertex -> vertex.getStation().shouldRouteToCentroid()).collect(Collectors.toUnmodifiableMap(v -> v.getStation().getId(), v -> v));
    }
}

