/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graph;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.ext.emission.EmissionRepository;
import org.opentripplanner.ext.stopconsolidation.StopConsolidationRepository;
import org.opentripplanner.framework.application.OtpAppException;
import org.opentripplanner.framework.geometry.CompactElevationProfile;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueSummary;
import org.opentripplanner.model.projectinfo.GraphFileHeader;
import org.opentripplanner.model.projectinfo.OtpProjectInfo;
import org.opentripplanner.routing.fares.FareServiceFactory;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.kryosupport.KryoBuilder;
import org.opentripplanner.service.osminfo.OsmInfoGraphBuildRepository;
import org.opentripplanner.service.vehicleparking.VehicleParkingRepository;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeRepository;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.standalone.config.RouterConfig;
import org.opentripplanner.street.model.StreetLimitationParameters;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.transit.model.basic.SubMode;
import org.opentripplanner.transit.model.network.RoutingTripPattern;
import org.opentripplanner.transit.service.TimetableRepository;
import org.opentripplanner.utils.lang.OtpNumberFormat;
import org.opentripplanner.utils.logging.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializedGraphObject
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(SerializedGraphObject.class);
    public final Graph graph;
    @Nullable
    public final OsmInfoGraphBuildRepository osmInfoGraphBuildRepository;
    public final TimetableRepository timetableRepository;
    public final WorldEnvelopeRepository worldEnvelopeRepository;
    private final Collection<Edge> edges;
    public final BuildConfig buildConfig;
    public final RouterConfig routerConfig;
    private final List<SubMode> allTransitSubModes;
    public final DataImportIssueSummary issueSummary;
    public final StopConsolidationRepository stopConsolidationRepository;
    private final int routingTripPatternCounter;
    public final EmissionRepository emissionRepository;
    public final FareServiceFactory fareServiceFactory;
    public final StreetLimitationParameters streetLimitationParameters;
    public final VehicleParkingRepository parkingRepository;

    public SerializedGraphObject(Graph graph, @Nullable OsmInfoGraphBuildRepository osmInfoGraphBuildRepository, TimetableRepository timetableRepository, WorldEnvelopeRepository worldEnvelopeRepository, VehicleParkingRepository parkingRepository, BuildConfig buildConfig, RouterConfig routerConfig, DataImportIssueSummary issueSummary, EmissionRepository emissionRepository, StopConsolidationRepository stopConsolidationRepository, StreetLimitationParameters streetLimitationParameters, FareServiceFactory fareServiceFactory) {
        this.graph = graph;
        this.edges = graph.getEdges();
        this.osmInfoGraphBuildRepository = osmInfoGraphBuildRepository;
        this.timetableRepository = timetableRepository;
        this.worldEnvelopeRepository = worldEnvelopeRepository;
        this.parkingRepository = parkingRepository;
        this.buildConfig = buildConfig;
        this.routerConfig = routerConfig;
        this.issueSummary = issueSummary;
        this.emissionRepository = emissionRepository;
        this.allTransitSubModes = SubMode.listAllCachedSubModes();
        this.routingTripPatternCounter = RoutingTripPattern.indexCounter();
        this.stopConsolidationRepository = stopConsolidationRepository;
        this.streetLimitationParameters = streetLimitationParameters;
        this.fareServiceFactory = fareServiceFactory;
    }

    public static void verifyTheOutputGraphIsWritableIfDataSourceExist(DataSource graphOutput) {
        if (graphOutput != null) {
            if (graphOutput.exists()) {
                LOG.info("Graph already exists and will be overwritten at the end of the build process. Graph: {}", (Object)graphOutput.path());
            }
            if (!graphOutput.isWritable()) {
                throw new RuntimeException("Cannot create or write to graph at: " + graphOutput.path());
            }
        }
    }

    public static SerializedGraphObject load(DataSource source) {
        return SerializedGraphObject.load(source.asInputStream(), source.path());
    }

    public static SerializedGraphObject load(File file) {
        try {
            return SerializedGraphObject.load(new FileInputStream(file), file.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            LOG.error("Graph file not found: " + String.valueOf(file), (Throwable)e);
            throw new OtpAppException(e.getMessage());
        }
    }

    public void reconstructEdgeLists() {
        for (Vertex v : this.graph.getVertices()) {
            v.initEdgeLists();
        }
        for (Edge e : this.edges) {
            Vertex fromVertex = e.getFromVertex();
            Vertex toVertex = e.getToVertex();
            fromVertex.addOutgoing(e);
            toVertex.addIncoming(e);
        }
    }

    public void save(@Nullable DataSource target) {
        if (target != null) {
            this.save(target.asOutputStream(), target.name(), target.size());
        } else {
            LOG.info("Not saving graph to disk, as requested.");
        }
    }

    private static SerializedGraphObject load(InputStream inputStream, String sourceDescription) {
        SerializedGraphObject serializedGraphObject;
        block10: {
            InputStream inputStream2 = inputStream;
            try {
                LOG.info("Reading graph from '{}'", (Object)sourceDescription);
                Input input = new Input(inputStream);
                SerializedGraphObject.validateGraphSerializationId(input.readBytes(GraphFileHeader.headerLength()), sourceDescription);
                Kryo kryo = KryoBuilder.create();
                SerializedGraphObject serObj = (SerializedGraphObject)kryo.readClassAndObject(input);
                SubMode.deserializeSubModeCache(serObj.allTransitSubModes);
                RoutingTripPattern.initIndexCounter(serObj.routingTripPatternCounter);
                CompactElevationProfile.setDistanceBetweenSamplesM(serObj.graph.getDistanceBetweenElevationSamples());
                LOG.debug("Graph read.");
                serObj.reconstructEdgeLists();
                serObj.timetableRepository.getSiteRepository().reindexAfterDeserialization();
                serObj.timetableRepository.index();
                SerializedGraphObject.logSerializationCompleteStatus(serObj.graph, serObj.timetableRepository);
                serializedGraphObject = serObj;
                if (inputStream2 == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error("IO exception while loading graph: {}", (Object)e.getLocalizedMessage(), (Object)e);
                    return null;
                }
                catch (KryoException ke) {
                    if (ke.getCause() instanceof IOException) {
                        LOG.error("IO exception while loading graph: {}", (Object)ke.getLocalizedMessage(), (Object)ke);
                        return null;
                    }
                    LOG.warn("Deserialization exception while loading graph: {}\n{}", (Object)sourceDescription, (Object)ke.getLocalizedMessage());
                    throw new OtpAppException("Unable to load graph. The deserialization failed. Is the loaded graph build with the same OTP version as you are using to load it? Graph: " + sourceDescription);
                }
            }
            inputStream2.close();
        }
        return serializedGraphObject;
    }

    private static OutputStream wrapOutputStreamWithProgressTracker(String name, OutputStream outputStream, long size) {
        return ProgressTracker.track((String)("Save " + name), (int)500000, (long)size, (OutputStream)outputStream, msg -> LOG.info(msg));
    }

    private static void validateGraphSerializationId(byte[] header, String sourceName) {
        GraphFileHeader expFileHeader = OtpProjectInfo.projectInfo().graphFileHeaderInfo;
        GraphFileHeader graphFileHeader = GraphFileHeader.parse(header);
        if (!expFileHeader.equals(graphFileHeader) && !expFileHeader.equals(graphFileHeader)) {
            throw new OtpAppException("The graph file is incompatible with this version of OTP. The OTP serialization version id '%s' do not match the id '%s' in '%s' file-header.", expFileHeader.otpSerializationVersionId(), graphFileHeader.otpSerializationVersionId(), sourceName);
        }
    }

    private void save(OutputStream outputStream, String graphName, long size) {
        LOG.info("Writing graph {}  ...", (Object)graphName);
        outputStream = SerializedGraphObject.wrapOutputStreamWithProgressTracker(graphName, outputStream, size);
        Kryo kryo = KryoBuilder.create();
        Output output = new Output(outputStream);
        output.write(OtpProjectInfo.projectInfo().graphFileHeaderInfo.header());
        kryo.writeClassAndObject(output, (Object)this);
        output.close();
        LOG.info("Graph written: {}", (Object)graphName);
    }

    private static void logSerializationCompleteStatus(Graph graph, TimetableRepository timetableRepository) {
        OtpNumberFormat f = new OtpNumberFormat();
        String nStops = f.formatNumber((Number)timetableRepository.getSiteRepository().stopIndexSize());
        String nTransfers = f.formatNumber((Number)timetableRepository.getTransferService().listAll().size());
        String nPatterns = f.formatNumber((Number)timetableRepository.getAllTripPatterns().size());
        String nVertices = f.formatNumber((Number)graph.countVertices());
        String nEdges = f.formatNumber((Number)graph.countEdges());
        LOG.info("Graph loaded.   |V|={} |E|={}", (Object)nVertices, (Object)nEdges);
        LOG.info("Transit loaded. |Stops|={} |Patterns|={} |ConstrainedTransfers|={}", new Object[]{nStops, nPatterns, nTransfers});
    }
}

