/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graph;

import com.google.common.annotations.VisibleForTesting;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.ext.dataoverlay.configuration.DataOverlayParameterBindings;
import org.opentripplanner.framework.geometry.CompactElevationProfile;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.model.calendar.openinghours.OpeningHoursCalendarService;
import org.opentripplanner.routing.graph.StreetIndex;
import org.opentripplanner.routing.linking.Scope;
import org.opentripplanner.routing.services.notes.StreetNotesService;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.vertex.StationCentroidVertex;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.model.vertex.VertexLabel;
import org.opentripplanner.transit.model.framework.Deduplicator;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Graph
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Graph.class);
    public final StreetNotesService streetNotesService = new StreetNotesService();
    private final Map<VertexLabel, Vertex> vertices = new ConcurrentHashMap<VertexLabel, Vertex>();
    public final transient Deduplicator deduplicator;
    @Nullable
    private final OpeningHoursCalendarService openingHoursCalendarService;
    private transient StreetIndex streetIndex;
    private Geometry convexHull = null;
    public boolean hasStreets = false;
    public Double ellipsoidToGeoidDifference = 0.0;
    public boolean hasElevation = false;
    public Double minElevation = null;
    public Double maxElevation = null;
    private double distanceBetweenElevationSamples;
    public long nextSplitNumber = 0L;
    public DataOverlayParameterBindings dataOverlayParameterBindings;

    @Inject
    public Graph(Deduplicator deduplicator, @Nullable OpeningHoursCalendarService openingHoursCalendarService) {
        this.deduplicator = deduplicator;
        this.openingHoursCalendarService = openingHoursCalendarService;
    }

    public Graph(Deduplicator deduplicator) {
        this(deduplicator, null);
    }

    public Graph() {
        this(new Deduplicator(), null);
    }

    public void addVertex(Vertex v) {
        Vertex old = this.vertices.put(v.getLabel(), v);
        if (old != null) {
            if (old == v) {
                LOG.error("repeatedly added the same vertex: {}", (Object)v);
            } else {
                LOG.error("duplicate vertex label in graph (added vertex to graph anyway): {}", (Object)v.getLabel());
            }
        }
    }

    public void removeEdge(Edge e) {
        this.removeEdge(e, Scope.PERMANENT);
    }

    public void removeEdge(Edge e, Scope scope) {
        this.streetNotesService.removeStaticNotes(e);
        e.remove();
        if (this.streetIndex != null) {
            this.streetIndex.remove(e, scope);
        }
    }

    @Nullable
    @VisibleForTesting
    public Vertex getVertex(VertexLabel label) {
        return this.vertices.get(label);
    }

    @Nullable
    @VisibleForTesting
    public Vertex getVertex(String label) {
        return this.vertices.get(VertexLabel.string(label));
    }

    public Collection<Vertex> getVertices() {
        return this.vertices.values();
    }

    public <T extends Vertex> List<T> getVerticesOfType(Class<T> cls) {
        return this.getVertices().stream().filter(cls::isInstance).map(cls::cast).collect(Collectors.toList());
    }

    @Nullable
    public TransitStopVertex getStopVertex(FeedScopedId id) {
        this.requireIndex();
        return this.streetIndex.findStopVertex(id).orElse(null);
    }

    public Optional<TransitStopVertex> findStopVertex(FeedScopedId stopId) {
        this.requireIndex();
        return this.streetIndex.findStopVertex(stopId);
    }

    public Optional<StationCentroidVertex> findStationCentroidVertex(FeedScopedId stopId) {
        this.requireIndex();
        return this.streetIndex.findStationCentroidVertex(stopId);
    }

    public Collection<Edge> getEdges() {
        HashSet<Edge> edges = new HashSet<Edge>();
        for (Vertex v : this.getVertices()) {
            edges.addAll(v.getOutgoing());
        }
        return edges;
    }

    public <T extends Edge> List<T> getEdgesOfType(Class<T> cls) {
        return this.getEdges().stream().filter(cls::isInstance).map(cls::cast).collect(Collectors.toList());
    }

    public Collection<StreetEdge> getStreetEdges() {
        return this.getEdgesOfType(StreetEdge.class);
    }

    public boolean containsVertex(Vertex v) {
        return v != null && this.vertices.get(v.getLabel()) == v;
    }

    public void remove(Vertex vertex) {
        this.vertices.remove(vertex.getLabel());
        if (this.streetIndex != null) {
            this.streetIndex.remove(vertex);
        }
    }

    public void removeIfUnconnected(Vertex v) {
        if (v.getDegreeIn() == 0 && v.getDegreeOut() == 0) {
            this.remove(v);
        }
    }

    public int countVertices() {
        return this.vertices.size();
    }

    public int countEdges() {
        int ne = 0;
        for (Vertex v : this.getVertices()) {
            ne += v.getDegreeOut();
        }
        return ne;
    }

    public void index() {
        LOG.info("Index street model...");
        this.streetIndex = new StreetIndex(this);
        LOG.info("Index street model complete.");
    }

    public void requestIndex() {
        if (this.streetIndex == null) {
            this.index();
        }
    }

    @Nullable
    public OpeningHoursCalendarService getOpeningHoursCalendarService() {
        return this.openingHoursCalendarService;
    }

    public Collection<Vertex> findVertices(Envelope env) {
        this.requireIndex();
        return this.streetIndex.findVertices(env);
    }

    public Collection<Edge> findEdges(Envelope env) {
        this.requireIndex();
        return this.streetIndex.findEdges(env);
    }

    public Collection<Edge> findEdges(Envelope env, Scope scope) {
        this.requireIndex();
        return this.streetIndex.findEdges(env, scope);
    }

    public void insert(StreetEdge edge, Scope scope) {
        this.requireIndex();
        this.streetIndex.insert(edge, scope);
    }

    public void calculateConvexHull() {
        this.convexHull = GeometryUtils.makeConvexHull(this.getVertices(), Vertex::getCoordinate);
    }

    public Geometry getConvexHull() {
        return this.convexHull;
    }

    public void initEllipsoidToGeoidDifference(double value, double lat, double lon) {
        this.ellipsoidToGeoidDifference = value;
        LOG.info("Computed ellipsoid/geoid offset at ({}, {}) as {}", new Object[]{lat, lon, this.ellipsoidToGeoidDifference});
    }

    public double getDistanceBetweenElevationSamples() {
        return this.distanceBetweenElevationSamples;
    }

    public void setDistanceBetweenElevationSamples(double distanceBetweenElevationSamples) {
        this.distanceBetweenElevationSamples = distanceBetweenElevationSamples;
        CompactElevationProfile.setDistanceBetweenSamplesM(distanceBetweenElevationSamples);
    }

    private void requireIndex() {
        if (this.streetIndex == null) {
            throw new IllegalStateException("Graph must be indexed before querying.");
        }
    }
}

