/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graph;

import java.util.stream.Stream;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.geometry.HashGridSpatialIndex;
import org.opentripplanner.routing.linking.Scope;
import org.opentripplanner.street.model.edge.Edge;

class EdgeSpatialIndex {
    private final HashGridSpatialIndex<Edge> permanentEdgeIndex = new HashGridSpatialIndex();
    private final HashGridSpatialIndex<Edge> realTimeEdgeIndex = new HashGridSpatialIndex();

    EdgeSpatialIndex() {
    }

    public void insert(Edge edge, Scope scope) {
        if (edge.hasGeometry()) {
            LineString geometry = edge.getGeometry();
            this.insert(geometry, edge, scope);
        }
    }

    public void insert(LineString geometry, Edge edge, Scope scope) {
        switch (scope) {
            case PERMANENT: {
                this.permanentEdgeIndex.insert(geometry, (Object)edge);
                break;
            }
            case REALTIME: {
                this.realTimeEdgeIndex.insert(geometry, (Object)edge);
                break;
            }
            case REQUEST: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void remove(Edge edge, Scope scope) {
        if (edge.hasGeometry()) {
            Envelope envelope = edge.getGeometry().getEnvelopeInternal();
            switch (scope) {
                case PERMANENT: {
                    this.permanentEdgeIndex.remove(envelope, edge);
                    break;
                }
                case REALTIME: {
                    this.realTimeEdgeIndex.remove(envelope, edge);
                    break;
                }
                case REQUEST: {
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    public final Stream<Edge> query(Envelope envelope, Scope scope) {
        return switch (scope) {
            default -> throw new MatchException(null, null);
            case Scope.PERMANENT, Scope.REALTIME -> this.permanentEdgeIndex.query(envelope).stream();
            case Scope.REQUEST -> Stream.concat(this.permanentEdgeIndex.query(envelope).stream(), this.realTimeEdgeIndex.query(envelope).stream());
        };
    }

    public void compact() {
        this.permanentEdgeIndex.compact();
    }
}

