/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.framework;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opentripplanner.api.resource.DebugOutput;
import org.opentripplanner.api.resource.TransitTimingOutput;
import org.opentripplanner.routing.api.request.RoutingTag;
import org.opentripplanner.routing.framework.MicrometerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugTimingAggregator {
    private static final Logger LOG = LoggerFactory.getLogger(DebugTimingAggregator.class);
    private static final long nanosToMillis = 1000000L;
    public static final String ROUTING_TOTAL = "routing.total";
    public static final String ROUTING_RAPTOR = "routing.raptor";
    private final Clock clock;
    private final Timer directStreetRouterTimer;
    private final Timer directFlexRouterTimer;
    private final Timer accessTimer;
    private final Timer egressTimer;
    private final DistributionSummary numAccessesDistribution;
    private final DistributionSummary numEgressesDistribution;
    private final Timer preCalculationTimer;
    private final Timer tripPatternFilterTimer;
    private final Timer accessEgressTimer;
    private final Timer raptorSearchTimer;
    private final Timer itineraryCreationTimer;
    private final Timer transitRouterTimer;
    private final Timer filteringTimer;
    private final Timer renderingTimer;
    private final Timer routingTotalTimer;
    private final Timer requestTotalTimer;
    private final Timer.Sample startedCalculating;
    private final List<String> messages = new ArrayList<String>();
    private Timer.Sample startedDirectStreetRouter;
    private long directStreetRouterTime;
    private Timer.Sample startedDirectFlexRouter;
    private long directFlexRouterTime;
    private Timer.Sample finishedPatternFiltering;
    private Timer.Sample finishedAccessEgress;
    private Timer.Sample finishedRaptorSearch;
    private Timer.Sample finishedRouters;
    private Timer.Sample finishedFiltering;
    private Timer.Sample startedAccessCalculating;
    private Timer.Sample startedEgressCalculating;
    private long accessTime;
    private long egressTime;
    private int numAccesses;
    private int numEgresses;
    private long precalculationTime;
    private Timer.Sample startedTransitRouterTime;
    private long tripPatternFilterTime;
    private long accessEgressTime;
    private long raptorSearchTime;
    private long itineraryCreationTime;
    private long transitRouterTime;
    private long filteringTime;
    private long renderingTime;
    private long requestTotalTime;

    public DebugTimingAggregator(MeterRegistry registry, Collection<RoutingTag> routingRequestTags) {
        List<Tag> tags = MicrometerUtils.mapTimingTags(routingRequestTags);
        this.clock = registry.config().clock();
        this.startedCalculating = Timer.start((Clock)this.clock);
        this.requestTotalTimer = Timer.builder((String)ROUTING_TOTAL).tags(tags).register(registry);
        this.routingTotalTimer = Timer.builder((String)"routing.router").tags(tags).register(registry);
        this.renderingTimer = Timer.builder((String)"routing.rendering").tags(tags).register(registry);
        this.filteringTimer = Timer.builder((String)"routing.filtering").tags(tags).register(registry);
        this.transitRouterTimer = Timer.builder((String)"routing.transit").tags(tags).register(registry);
        this.itineraryCreationTimer = Timer.builder((String)"routing.itineraryCreation").tags(tags).register(registry);
        this.raptorSearchTimer = Timer.builder((String)ROUTING_RAPTOR).tags(tags).register(registry);
        this.accessEgressTimer = Timer.builder((String)"routing.accessEgress").tags(tags).register(registry);
        this.tripPatternFilterTimer = Timer.builder((String)"routing.tripPatternFiltering").tags(tags).register(registry);
        this.preCalculationTimer = Timer.builder((String)"routing.preCalculation").tags(tags).register(registry);
        this.numEgressesDistribution = DistributionSummary.builder((String)"routing.numEgress").tags(tags).register(registry);
        this.numAccessesDistribution = DistributionSummary.builder((String)"routing.numAccess").tags(tags).register(registry);
        this.egressTimer = Timer.builder((String)"routing.egress").tags(tags).register(registry);
        this.accessTimer = Timer.builder((String)"routing.access").tags(tags).register(registry);
        this.directFlexRouterTimer = Timer.builder((String)"routing.directFlex").tags(tags).register(registry);
        this.directStreetRouterTimer = Timer.builder((String)"routing.directStreet").tags(tags).register(registry);
    }

    public DebugTimingAggregator() {
        this((MeterRegistry)Metrics.globalRegistry, List.of());
    }

    public void finishedPrecalculating() {
        if (this.startedCalculating == null) {
            return;
        }
        this.precalculationTime = this.startedCalculating.stop(this.preCalculationTimer);
        this.log("\u250c  Routing initialization", this.precalculationTime);
    }

    public void startedDirectStreetRouter() {
        this.startedDirectStreetRouter = Timer.start((Clock)this.clock);
    }

    public void finishedDirectStreetRouter() {
        if (this.startedDirectStreetRouter == null) {
            return;
        }
        this.directStreetRouterTime = this.startedDirectStreetRouter.stop(this.directStreetRouterTimer);
    }

    public void startedDirectFlexRouter() {
        this.startedDirectFlexRouter = Timer.start((Clock)this.clock);
    }

    public void finishedDirectFlexRouter() {
        if (this.startedDirectFlexRouter == null) {
            return;
        }
        this.directFlexRouterTime = this.startedDirectFlexRouter.stop(this.directFlexRouterTimer);
    }

    public void startedTransitRouting() {
        this.startedTransitRouterTime = Timer.start((Clock)this.clock);
    }

    public void finishedPatternFiltering() {
        this.finishedPatternFiltering = Timer.start((Clock)this.clock);
        if (this.startedTransitRouterTime == null) {
            return;
        }
        this.tripPatternFilterTime = this.startedTransitRouterTime.stop(this.tripPatternFilterTimer);
    }

    public void startedAccessCalculating() {
        this.startedAccessCalculating = Timer.start((Clock)this.clock);
    }

    public void finishedAccessCalculating() {
        if (this.startedAccessCalculating == null) {
            return;
        }
        this.accessTime = this.startedAccessCalculating.stop(this.accessTimer);
    }

    public void startedEgressCalculating() {
        this.startedEgressCalculating = Timer.start((Clock)this.clock);
    }

    public void finishedEgressCalculating() {
        if (this.startedEgressCalculating == null) {
            return;
        }
        this.egressTime = this.startedEgressCalculating.stop(this.egressTimer);
    }

    public void finishedAccessEgress(int numAccesses, int numEgresses) {
        this.finishedAccessEgress = Timer.start((Clock)this.clock);
        if (this.finishedPatternFiltering == null) {
            return;
        }
        this.accessEgressTime = this.finishedPatternFiltering.stop(this.accessEgressTimer);
        this.numAccesses = numAccesses;
        this.numAccessesDistribution.record((double)numAccesses);
        this.numEgresses = numEgresses;
        this.numEgressesDistribution.record((double)numEgresses);
    }

    public void finishedRaptorSearch() {
        this.finishedRaptorSearch = Timer.start((Clock)this.clock);
        if (this.finishedAccessEgress == null) {
            return;
        }
        this.raptorSearchTime = this.finishedAccessEgress.stop(this.raptorSearchTimer);
    }

    public void finishedItineraryCreation() {
        if (this.finishedRaptorSearch == null) {
            return;
        }
        this.itineraryCreationTime = this.finishedRaptorSearch.stop(this.itineraryCreationTimer);
    }

    public void finishedTransitRouter() {
        if (this.startedTransitRouterTime == null) {
            return;
        }
        this.transitRouterTime = this.startedTransitRouterTime.stop(this.transitRouterTimer);
    }

    public void finishedRouting() {
        if (this.startedCalculating == null) {
            return;
        }
        long routingTotalTime = this.startedCalculating.stop(this.routingTotalTimer);
        this.finishedRouters = Timer.start((Clock)this.clock);
        if (this.directStreetRouterTime > 0L) {
            this.log("\u251c  Direct street routing", this.directStreetRouterTime);
        }
        if (this.directFlexRouterTime > 0L) {
            this.log("\u251c  Direct flex routing", this.directFlexRouterTime);
        }
        if (this.transitRouterTime > 0L) {
            this.log("\u2502\u250c Creating raptor data model", this.tripPatternFilterTime);
            this.log("\u2502\u251c Access routing (" + this.numAccesses + " accesses)", this.accessTime);
            this.log("\u2502\u251c Egress routing (" + this.numEgresses + " egresses)", this.egressTime);
            this.log("\u2502\u2502 Access/Egress routing", this.accessEgressTime);
            this.log("\u2502\u251c Main routing", this.raptorSearchTime);
            this.log("\u2502\u251c Creating itineraries", this.itineraryCreationTime);
            this.log("\u251c\u2534 Transit routing total", this.transitRouterTime);
        }
        this.log("\u2502  Routing total: ", routingTotalTime);
    }

    public void finishedFiltering() {
        this.finishedFiltering = Timer.start((Clock)this.clock);
        if (this.finishedRouters == null) {
            return;
        }
        this.filteringTime = this.finishedRouters.stop(this.filteringTimer);
        this.log("\u251c  Filtering itineraries", this.filteringTime);
    }

    public DebugOutput finishedRendering() {
        if (this.finishedFiltering == null || this.startedCalculating == null) {
            return null;
        }
        this.renderingTime = this.finishedFiltering.stop(this.renderingTimer);
        this.requestTotalTime = this.startedCalculating.stop(this.requestTotalTimer);
        this.log("\u251c  Converting model objects", this.renderingTime);
        this.log("\u2534  Request total", this.requestTotalTime);
        this.messages.forEach(m -> LOG.debug(m));
        return this.getDebugOutput();
    }

    public DebugOutput getDebugOutput() {
        return new DebugOutput(this.precalculationTime, this.directStreetRouterTime, this.transitRouterTime, this.filteringTime, this.renderingTime, this.requestTotalTime, new TransitTimingOutput(this.tripPatternFilterTime, this.accessEgressTime, this.raptorSearchTime, this.itineraryCreationTime));
    }

    private void log(String msg, long nanos) {
        this.messages.add(String.format("%-36s: %5s ms", msg, nanos / 1000000L));
    }
}

