/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.error;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.opentripplanner.routing.api.response.InputField;
import org.opentripplanner.routing.api.response.RoutingError;
import org.opentripplanner.routing.api.response.RoutingErrorCode;

public class RoutingValidationException
extends RuntimeException {
    private final List<RoutingError> routingErrors;

    public RoutingValidationException(List<RoutingError> routingErrors) {
        this.routingErrors = routingErrors;
    }

    public static void unwrapAndRethrowCompletionException(CompletionException e) {
        Throwable throwable = e.getCause();
        if (throwable instanceof RuntimeException) {
            RuntimeException cause = (RuntimeException)throwable;
            throw cause;
        }
        throw e;
    }

    public static void unwrapAndRethrowExecutionException(ExecutionException e) {
        Throwable throwable = e.getCause();
        if (throwable instanceof RuntimeException) {
            RuntimeException cause = (RuntimeException)throwable;
            throw cause;
        }
        throw new RuntimeException(e);
    }

    public List<RoutingError> getRoutingErrors() {
        return this.routingErrors;
    }

    @Override
    public String getMessage() {
        return this.routingErrors.stream().map(Objects::toString).collect(Collectors.joining("\n"));
    }

    public boolean isFromLocationNotFound() {
        return this.isLocationNotFound(InputField.FROM_PLACE);
    }

    public boolean isToLocationNotFound() {
        return this.isLocationNotFound(InputField.TO_PLACE);
    }

    public boolean isFromToLocationNotFound() {
        return this.isFromLocationNotFound() && this.isToLocationNotFound();
    }

    private boolean isLocationNotFound(InputField location) {
        return this.routingErrors != null && this.routingErrors.stream().anyMatch(routingError -> routingError.code == RoutingErrorCode.LOCATION_NOT_FOUND && routingError.inputField == location);
    }
}

