/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.response;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nullable;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class TripSearchMetadata {
    public Duration searchWindowUsed;
    @Deprecated
    public Instant prevDateTime;
    @Deprecated
    public Instant nextDateTime;

    private TripSearchMetadata(Duration searchWindowUsed, Instant prevDateTime, Instant nextDateTime) {
        this.searchWindowUsed = searchWindowUsed;
        this.prevDateTime = prevDateTime;
        this.nextDateTime = nextDateTime;
    }

    public static TripSearchMetadata createForArriveBy(Instant earliestDepartureTimeUsed, Duration searchWindowUsed, @Nullable Instant firstDepartureTime) {
        Instant actualEdt = firstDepartureTime == null ? earliestDepartureTimeUsed : firstDepartureTime.minusSeconds(60L).truncatedTo(ChronoUnit.MINUTES);
        return new TripSearchMetadata(searchWindowUsed, actualEdt.minus(searchWindowUsed), earliestDepartureTimeUsed.plus(searchWindowUsed));
    }

    public static TripSearchMetadata createForDepartAfter(Instant requestDepartureTime, Duration searchWindowUsed, Instant lastDepartureTime) {
        Instant nextDateTime = lastDepartureTime == null ? requestDepartureTime.plus(searchWindowUsed) : lastDepartureTime.plusSeconds(60L).truncatedTo(ChronoUnit.MINUTES);
        return new TripSearchMetadata(searchWindowUsed, requestDepartureTime.minus(searchWindowUsed), nextDateTime);
    }

    public String toString() {
        return ToStringBuilder.of(TripSearchMetadata.class).addDuration("searchWindowUsed", this.searchWindowUsed).addObj("nextDateTime", (Object)this.nextDateTime).addObj("prevDateTime", (Object)this.prevDateTime).toString();
    }
}

