/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.via;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.routing.api.request.via.AbstractViaLocation;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.utils.time.DurationUtils;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class VisitViaLocation
extends AbstractViaLocation {
    private static final Duration MINIMUM_WAIT_TIME_MAX_LIMIT = Duration.ofHours(24L);
    private final Duration minimumWaitTime;
    private final List<WgsCoordinate> coordinates;

    public VisitViaLocation(@Nullable String label, @Nullable Duration minimumWaitTime, List<FeedScopedId> stopLocationIds, List<WgsCoordinate> coordinates) {
        super(label, stopLocationIds);
        this.minimumWaitTime = DurationUtils.requireNonNegative((Duration)(minimumWaitTime == null ? Duration.ZERO : minimumWaitTime), (Duration)MINIMUM_WAIT_TIME_MAX_LIMIT, (String)"minimumWaitTime");
        this.coordinates = List.copyOf(coordinates);
        if (this.stopLocationIds().isEmpty() && this.coordinates().isEmpty()) {
            throw new IllegalArgumentException("A via location must have at least one stop location or a coordinate." + (String)(label == null ? "" : " Label: " + label));
        }
    }

    @Override
    public Duration minimumWaitTime() {
        return this.minimumWaitTime;
    }

    @Override
    public boolean isPassThroughLocation() {
        return false;
    }

    @Override
    public List<WgsCoordinate> coordinates() {
        return this.coordinates;
    }

    public String toString() {
        return ToStringBuilder.of(VisitViaLocation.class).addObj("label", (Object)this.label()).addDuration("minimumWaitTime", this.minimumWaitTime, Duration.ZERO).addCol("stopLocationIds", this.stopLocationIds()).addObj("coordinates", this.coordinates).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VisitViaLocation that = (VisitViaLocation)o;
        return Objects.equals(this.minimumWaitTime, that.minimumWaitTime) && Objects.equals(this.coordinates, that.coordinates);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.minimumWaitTime, this.coordinates);
    }
}

