/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.request.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class TransitGroupSelect {
    private static final TransitGroupSelect DEFAULT = new TransitGroupSelect();
    private final List<TransitMode> modes;
    private final List<String> subModeRegexp;
    private final List<FeedScopedId> agencyIds;
    private final List<FeedScopedId> routeIds;

    public TransitGroupSelect() {
        this.modes = List.of();
        this.subModeRegexp = List.of();
        this.agencyIds = List.of();
        this.routeIds = List.of();
    }

    private TransitGroupSelect(Builder builder) {
        this.modes = List.copyOf(builder.modes.stream().sorted(Comparator.comparingInt(Enum::ordinal)).distinct().toList());
        this.subModeRegexp = List.copyOf(builder.subModeRegexp.stream().sorted().distinct().toList());
        this.agencyIds = List.copyOf(builder.agencyIds.stream().sorted().distinct().toList());
        this.routeIds = List.copyOf(builder.routeIds.stream().sorted().distinct().toList());
    }

    public static Builder of() {
        return new Builder(DEFAULT);
    }

    public List<TransitMode> modes() {
        return this.modes;
    }

    public List<String> subModeRegexp() {
        return this.subModeRegexp;
    }

    public List<FeedScopedId> agencyIds() {
        return this.agencyIds;
    }

    public List<FeedScopedId> routeIds() {
        return this.routeIds;
    }

    public boolean isEmpty() {
        return this.modes.isEmpty() && this.subModeRegexp.isEmpty() && this.agencyIds.isEmpty() && this.routeIds.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransitGroupSelect that = (TransitGroupSelect)o;
        return Objects.equals(this.modes, that.modes) && Objects.equals(this.subModeRegexp, that.subModeRegexp) && Objects.equals(this.agencyIds, that.agencyIds) && Objects.equals(this.routeIds, that.routeIds);
    }

    public int hashCode() {
        return Objects.hash(this.modes, this.subModeRegexp, this.agencyIds, this.routeIds);
    }

    public String toString() {
        return this.isEmpty() ? "EMPTY" : ToStringBuilder.ofEmbeddedType().addCol("modes", this.modes).addCol("subModeRegexp", this.subModeRegexp).addCol("agencyIds", this.agencyIds).addCol("routeIds", this.routeIds).toString();
    }

    public static class Builder {
        private final TransitGroupSelect original;
        private final List<TransitMode> modes;
        private final List<String> subModeRegexp;
        private final List<FeedScopedId> agencyIds;
        private final List<FeedScopedId> routeIds;

        public Builder(TransitGroupSelect original) {
            this.original = original;
            this.modes = new ArrayList<TransitMode>(original.modes);
            this.subModeRegexp = new ArrayList<String>(original.subModeRegexp);
            this.agencyIds = new ArrayList<FeedScopedId>(original.agencyIds);
            this.routeIds = new ArrayList<FeedScopedId>(original.routeIds);
        }

        public Builder addModes(Collection<TransitMode> modes) {
            this.modes.addAll(modes);
            return this;
        }

        public Builder addSubModeRegexp(Collection<String> subModeRegexp) {
            this.subModeRegexp.addAll(subModeRegexp);
            return this;
        }

        public Builder addAgencyIds(Collection<FeedScopedId> agencyIds) {
            this.agencyIds.addAll(agencyIds);
            return this;
        }

        public Builder addRouteIds(Collection<FeedScopedId> routeIds) {
            this.routeIds.addAll(routeIds);
            return this;
        }

        public TransitGroupSelect build() {
            TransitGroupSelect obj = new TransitGroupSelect(this);
            return this.original.equals(obj) ? this.original : obj;
        }
    }
}

