/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.request.filter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opentripplanner.routing.api.request.request.filter.SelectRequest;
import org.opentripplanner.routing.api.request.request.filter.TransitFilter;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class TransitFilterRequest
implements Serializable,
TransitFilter {
    private final SelectRequest[] select;
    private final SelectRequest[] not;

    public TransitFilterRequest(Builder builder) {
        this.select = (SelectRequest[])builder.select.toArray(SelectRequest[]::new);
        this.not = (SelectRequest[])builder.not.toArray(SelectRequest[]::new);
    }

    public List<SelectRequest> select() {
        return Collections.unmodifiableList(Arrays.asList(this.select));
    }

    public List<SelectRequest> not() {
        return Collections.unmodifiableList(Arrays.asList(this.not));
    }

    public static Builder of() {
        return new Builder();
    }

    @Override
    public boolean isSubModePredicate() {
        for (SelectRequest selectRequest : this.select) {
            if (selectRequest.transportModeFilter() == null || !selectRequest.transportModeFilter().isSubMode()) continue;
            return true;
        }
        for (SelectRequest selectRequest : this.not) {
            if (selectRequest.transportModeFilter() == null || !selectRequest.transportModeFilter().isSubMode()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchTripPattern(TripPattern tripPattern) {
        if (this.select.length != 0) {
            boolean anyMatch = false;
            SelectRequest[] selectRequestArray = this.select;
            int n = selectRequestArray.length;
            for (int i = 0; i < n; ++i) {
                SelectRequest s = selectRequestArray[i];
                if (!s.matches(tripPattern)) continue;
                anyMatch = true;
                break;
            }
            if (!anyMatch) {
                return false;
            }
        }
        for (SelectRequest s : this.not) {
            if (!s.matches(tripPattern)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matchTripTimes(TripTimes tripTimes) {
        if (this.select.length != 0) {
            boolean anyMatch = false;
            SelectRequest[] selectRequestArray = this.select;
            int n = selectRequestArray.length;
            for (int i = 0; i < n; ++i) {
                SelectRequest selectRequest = selectRequestArray[i];
                if (!selectRequest.matchesSelect(tripTimes)) continue;
                anyMatch = true;
                break;
            }
            if (!anyMatch) {
                return false;
            }
        }
        for (SelectRequest s : this.not) {
            if (!s.matchesNot(tripTimes)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.select.length == 0 && this.not.length == 0) {
            return "ALL";
        }
        return ToStringBuilder.ofEmbeddedType().addCol("select", Arrays.asList(this.select)).addCol("not", Arrays.asList(this.not)).toString();
    }

    public static class Builder {
        private final List<SelectRequest> select = new ArrayList<SelectRequest>();
        private final List<SelectRequest> not = new ArrayList<SelectRequest>();

        public Builder addSelect(SelectRequest selectRequest) {
            this.select.add(selectRequest);
            return this;
        }

        public Builder addNot(SelectRequest selectRequest) {
            this.not.add(selectRequest);
            return this;
        }

        public TransitFilterRequest build() {
            return new TransitFilterRequest(this);
        }
    }
}

