/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.request;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.opentripplanner.model.modes.ExcludeAllTransitFilter;
import org.opentripplanner.routing.api.request.DebugRaptor;
import org.opentripplanner.routing.api.request.request.TransitRequestBuilder;
import org.opentripplanner.routing.api.request.request.filter.AllowAllTransitFilter;
import org.opentripplanner.routing.api.request.request.filter.TransitFilter;
import org.opentripplanner.routing.api.request.request.filter.TransitGroupSelect;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class TransitRequest
implements Serializable {
    public static final TransitRequest DEFAULT = new TransitRequest(List.of(AllowAllTransitFilter.of()), List.of(), List.of(), List.of(), List.of(), List.of(), DebugRaptor.defaltValue());
    private final List<TransitFilter> filters;
    private final List<FeedScopedId> unpreferredAgencies;
    private final List<FeedScopedId> unpreferredRoutes;
    private final List<FeedScopedId> bannedTrips;
    private final List<TransitGroupSelect> priorityGroupsByAgency;
    private final List<TransitGroupSelect> priorityGroupsGlobal;
    private final DebugRaptor raptorDebugging;

    TransitRequest(List<TransitFilter> filters, List<FeedScopedId> unpreferredAgencies, List<FeedScopedId> unpreferredRoutes, List<FeedScopedId> bannedTrips, List<TransitGroupSelect> priorityGroupsByAgency, List<TransitGroupSelect> priorityGroupsGlobal, DebugRaptor raptorDebugging) {
        this.filters = filters;
        this.unpreferredAgencies = unpreferredAgencies;
        this.unpreferredRoutes = unpreferredRoutes;
        this.bannedTrips = bannedTrips;
        this.priorityGroupsByAgency = priorityGroupsByAgency;
        this.priorityGroupsGlobal = priorityGroupsGlobal;
        this.raptorDebugging = raptorDebugging;
    }

    public static TransitRequestBuilder of() {
        return DEFAULT.copyOf();
    }

    public TransitRequestBuilder copyOf() {
        return new TransitRequestBuilder(this);
    }

    @Deprecated
    public List<FeedScopedId> bannedTrips() {
        return this.bannedTrips;
    }

    public List<TransitFilter> filters() {
        return this.filters;
    }

    public List<TransitGroupSelect> priorityGroupsByAgency() {
        return this.priorityGroupsByAgency;
    }

    public List<TransitGroupSelect> priorityGroupsGlobal() {
        return this.priorityGroupsGlobal;
    }

    public List<FeedScopedId> unpreferredAgencies() {
        return this.unpreferredAgencies;
    }

    public List<FeedScopedId> unpreferredRoutes() {
        return this.unpreferredRoutes;
    }

    public DebugRaptor raptorDebugging() {
        return this.raptorDebugging;
    }

    public boolean enabled() {
        return this.filters.stream().noneMatch(ExcludeAllTransitFilter.class::isInstance);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransitRequest that = (TransitRequest)o;
        return Objects.equals(this.filters, that.filters) && Objects.equals(this.unpreferredAgencies, that.unpreferredAgencies) && Objects.equals(this.unpreferredRoutes, that.unpreferredRoutes) && Objects.equals(this.bannedTrips, that.bannedTrips) && Objects.equals(this.priorityGroupsByAgency, that.priorityGroupsByAgency) && Objects.equals(this.priorityGroupsGlobal, that.priorityGroupsGlobal) && Objects.equals(this.raptorDebugging, that.raptorDebugging);
    }

    public int hashCode() {
        return Objects.hash(this.filters, this.unpreferredAgencies, this.unpreferredRoutes, this.bannedTrips, this.priorityGroupsByAgency, this.priorityGroupsGlobal, this.raptorDebugging);
    }

    public String toString() {
        return ToStringBuilder.ofEmbeddedType().addCol("filters", this.filters, TransitRequest.DEFAULT.filters).addCol("unpreferredAgencies", this.unpreferredAgencies).addCol("unpreferredRoutes", this.unpreferredRoutes).addCol("bannedTrips", this.bannedTrips).addCol("priorityGroupsByAgency", this.priorityGroupsByAgency).addCol("priorityGroupsGlobal", this.priorityGroupsGlobal).addObj("raptorDebugging", (Object)this.raptorDebugging, (Object)TransitRequest.DEFAULT.raptorDebugging).toString();
    }
}

