/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.request;

import java.io.Serializable;
import java.util.function.Consumer;
import org.opentripplanner.routing.api.request.RequestModes;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.request.JourneyRequest;
import org.opentripplanner.routing.api.request.request.StreetRequest;
import org.opentripplanner.routing.api.request.request.TransitRequest;
import org.opentripplanner.routing.api.request.request.TransitRequestBuilder;

public class JourneyRequestBuilder
implements Serializable {
    private TransitRequest transit;
    private StreetRequest access;
    private StreetRequest egress;
    private StreetRequest transfer;
    private StreetRequest direct;
    private boolean wheelchair;
    private final JourneyRequest original;

    JourneyRequestBuilder(JourneyRequest original) {
        this.original = original;
        this.transit = original.transit();
        this.access = original.access();
        this.egress = original.egress();
        this.transfer = original.transfer();
        this.direct = original.direct();
        this.wheelchair = original.wheelchair();
    }

    public JourneyRequestBuilder withTransit(TransitRequest transit) {
        this.transit = transit;
        return this;
    }

    public JourneyRequestBuilder withTransit(Consumer<TransitRequestBuilder> body) {
        return this.withTransit(this.transit.copyOf().apply(body).build());
    }

    public JourneyRequestBuilder withAccess(StreetRequest access) {
        this.access = access;
        return this;
    }

    public JourneyRequestBuilder withEgress(StreetRequest egress) {
        this.egress = egress;
        return this;
    }

    public JourneyRequestBuilder withTransfer(StreetRequest transfer) {
        this.transfer = transfer;
        return this;
    }

    public JourneyRequestBuilder withDirect(StreetRequest direct) {
        this.direct = direct;
        return this;
    }

    public JourneyRequestBuilder withoutDirect() {
        return this.withDirect(new StreetRequest(StreetMode.NOT_SET));
    }

    public JourneyRequestBuilder withWheelchair(boolean wheelchair) {
        this.wheelchair = wheelchair;
        return this;
    }

    public JourneyRequestBuilder setAllModes(StreetMode mode) {
        StreetRequest value = new StreetRequest(mode);
        this.withAccess(value);
        this.withEgress(value);
        this.withTransfer(value);
        this.withDirect(value);
        return this;
    }

    public JourneyRequestBuilder setModes(RequestModes modes) {
        this.withAccess(new StreetRequest(modes.accessMode));
        this.withEgress(new StreetRequest(modes.egressMode));
        this.withTransfer(new StreetRequest(modes.transferMode));
        this.withDirect(new StreetRequest(modes.directMode));
        return this;
    }

    public JourneyRequestBuilder apply(Consumer<JourneyRequestBuilder> body) {
        body.accept(this);
        return this;
    }

    public JourneyRequest build() {
        JourneyRequest value = new JourneyRequest(this.transit, this.access, this.egress, this.transfer, this.direct, this.wheelchair);
        return this.original.equals(value) ? this.original : value;
    }
}

