/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.request;

import java.io.Serializable;
import java.util.Objects;
import org.opentripplanner.routing.api.request.RequestModes;
import org.opentripplanner.routing.api.request.request.JourneyRequestBuilder;
import org.opentripplanner.routing.api.request.request.StreetRequest;
import org.opentripplanner.routing.api.request.request.TransitRequest;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class JourneyRequest
implements Serializable {
    public static final JourneyRequest DEFAULT = new JourneyRequest(TransitRequest.DEFAULT, StreetRequest.DEFAULT, StreetRequest.DEFAULT, StreetRequest.DEFAULT, StreetRequest.DEFAULT, false);
    private final TransitRequest transit;
    private final StreetRequest access;
    private final StreetRequest egress;
    private final StreetRequest transfer;
    private final StreetRequest direct;
    private final boolean wheelchair;

    JourneyRequest(TransitRequest transit, StreetRequest access, StreetRequest egress, StreetRequest transfer, StreetRequest direct, boolean wheelchair) {
        this.transit = transit;
        this.access = access;
        this.egress = egress;
        this.transfer = transfer;
        this.direct = direct;
        this.wheelchair = wheelchair;
    }

    public static JourneyRequestBuilder of() {
        return DEFAULT.copyOf();
    }

    public JourneyRequestBuilder copyOf() {
        return new JourneyRequestBuilder(this);
    }

    public TransitRequest transit() {
        return this.transit;
    }

    public StreetRequest access() {
        return this.access;
    }

    public StreetRequest egress() {
        return this.egress;
    }

    public StreetRequest transfer() {
        return this.transfer;
    }

    public StreetRequest direct() {
        return this.direct;
    }

    public boolean wheelchair() {
        return this.wheelchair;
    }

    public RequestModes modes() {
        return RequestModes.of().withAccessMode(this.access.mode()).withEgressMode(this.egress.mode()).withTransferMode(this.transfer.mode()).withDirectMode(this.direct.mode()).build();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JourneyRequest that = (JourneyRequest)o;
        return this.wheelchair == that.wheelchair && Objects.equals(this.transit, that.transit) && Objects.equals(this.access, that.access) && Objects.equals(this.egress, that.egress) && Objects.equals(this.transfer, that.transfer) && Objects.equals(this.direct, that.direct);
    }

    public int hashCode() {
        return Objects.hash(this.transit, this.access, this.egress, this.transfer, this.direct, this.wheelchair);
    }

    public String toString() {
        return ToStringBuilder.ofEmbeddedType().addObj("transit", (Object)this.transit, (Object)JourneyRequest.DEFAULT.transit).addObj("access", (Object)this.access, (Object)JourneyRequest.DEFAULT.access).addObj("egress", (Object)this.egress, (Object)JourneyRequest.DEFAULT.egress).addObj("transfer", (Object)this.transfer, (Object)JourneyRequest.DEFAULT.transfer).addObj("direct", (Object)this.direct, (Object)JourneyRequest.DEFAULT.direct).addBoolIfTrue("wheelchair", Boolean.valueOf(this.wheelchair)).toString();
    }
}

