/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference.filter;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.opentripplanner.service.vehicleparking.model.VehicleParking;

public sealed interface VehicleParkingSelect {
    public boolean matches(VehicleParking var1);

    public boolean isEmpty();

    public List<String> tags();

    public static final class TagsSelect
    implements VehicleParkingSelect {
        private final Set<String> tags;

        public TagsSelect(Set<String> tags) {
            this.tags = tags;
        }

        @Override
        public List<String> tags() {
            return this.tags.stream().toList();
        }

        @Override
        public boolean matches(VehicleParking p) {
            return !Collections.disjoint(this.tags, p.getTags());
        }

        @Override
        public boolean isEmpty() {
            return this.tags.isEmpty();
        }

        public String toString() {
            return "tags=" + String.valueOf(this.tags.stream().sorted().toList());
        }
    }
}

