/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference.filter;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.opentripplanner.routing.api.request.preference.filter.VehicleParkingSelect;
import org.opentripplanner.service.vehicleparking.model.VehicleParking;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class VehicleParkingFilter
implements Serializable {
    private final VehicleParkingSelect[] not;
    private final VehicleParkingSelect[] select;

    public VehicleParkingFilter(Collection<VehicleParkingSelect> not, Collection<VehicleParkingSelect> select) {
        this.not = VehicleParkingFilter.makeFilter(not);
        this.select = VehicleParkingFilter.makeFilter(select);
    }

    public VehicleParkingFilter(VehicleParkingSelect not, VehicleParkingSelect select) {
        this(List.of(not), List.of(select));
    }

    public List<VehicleParkingSelect> not() {
        return Arrays.asList(this.not);
    }

    public List<VehicleParkingSelect> select() {
        return Arrays.asList(this.select);
    }

    public static VehicleParkingFilter empty() {
        return new VehicleParkingFilter(List.of(), List.of());
    }

    public boolean matches(VehicleParking p) {
        for (VehicleParkingSelect n : this.not) {
            if (!n.matches(p)) continue;
            return false;
        }
        if (this.select.length == 0) {
            return true;
        }
        for (VehicleParkingSelect s : this.select) {
            if (!s.matches(p)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addCol("not", Arrays.asList(this.not)).addCol("select", Arrays.asList(this.select)).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VehicleParkingFilter that = (VehicleParkingFilter)o;
        return Arrays.equals(this.not, that.not) && Arrays.equals(this.select, that.select);
    }

    public int hashCode() {
        return Arrays.hashCode(this.not) + Arrays.hashCode(this.select);
    }

    private static VehicleParkingSelect[] makeFilter(Collection<VehicleParkingSelect> select) {
        return (VehicleParkingSelect[])select.stream().filter(f -> !f.isEmpty()).toArray(VehicleParkingSelect[]::new);
    }
}

