/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.framework.model.Units;
import org.opentripplanner.routing.api.request.preference.AccessibilityPreferences;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class WheelchairPreferences
implements Serializable {
    private static final int DEFAULT_INACCESSIBLE_STREET_RELUCTANCE = 25;
    private static final double DEFAULT_MAX_SLOPE = 0.083;
    private static final int DEFAULT_SLOPE_EXCEEDED_RELUCTANCE = 1;
    private static final int DEFAULT_STAIRS_RELUCTANCE = 100;
    private static final AccessibilityPreferences DEFAULT_ELEVATOR_PREFERENCES = AccessibilityPreferences.ofCost(20, 3600);
    public static final AccessibilityPreferences DEFAULT_COSTS = AccessibilityPreferences.ofCost(600, 3600);
    public static final WheelchairPreferences DEFAULT = new WheelchairPreferences(AccessibilityPreferences.ofOnlyAccessible(), AccessibilityPreferences.ofOnlyAccessible(), DEFAULT_ELEVATOR_PREFERENCES, 25.0, 0.083, 1.0, 100.0);
    private AccessibilityPreferences trip;
    private AccessibilityPreferences stop;
    private AccessibilityPreferences elevator;
    private double inaccessibleStreetReluctance;
    private double maxSlope;
    private double slopeExceededReluctance;
    private double stairsReluctance;

    private WheelchairPreferences(AccessibilityPreferences trip, AccessibilityPreferences stop, AccessibilityPreferences elevator, double inaccessibleStreetReluctance, double maxSlope, double slopeExceededReluctance, double stairsReluctance) {
        this.trip = Objects.requireNonNull(trip);
        this.stop = Objects.requireNonNull(stop);
        this.elevator = Objects.requireNonNull(elevator);
        this.inaccessibleStreetReluctance = Units.reluctance(inaccessibleStreetReluctance);
        this.maxSlope = Units.ratio(maxSlope);
        this.slopeExceededReluctance = Units.reluctance(slopeExceededReluctance);
        this.stairsReluctance = Units.reluctance(stairsReluctance);
    }

    private WheelchairPreferences(Builder builder) {
        this.trip = builder.trip;
        this.stop = builder.stop;
        this.elevator = builder.elevator;
        this.inaccessibleStreetReluctance = Units.reluctance(builder.inaccessibleStreetReluctance);
        this.maxSlope = Units.ratio(builder.maxSlope);
        this.slopeExceededReluctance = Units.reluctance(builder.slopeExceededReluctance);
        this.stairsReluctance = Units.reluctance(builder.stairsReluctance);
    }

    public static Builder of() {
        return DEFAULT.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public AccessibilityPreferences trip() {
        return this.trip;
    }

    public AccessibilityPreferences stop() {
        return this.stop;
    }

    public AccessibilityPreferences elevator() {
        return this.elevator;
    }

    public double inaccessibleStreetReluctance() {
        return this.inaccessibleStreetReluctance;
    }

    public double maxSlope() {
        return this.maxSlope;
    }

    public double slopeExceededReluctance() {
        return this.slopeExceededReluctance;
    }

    public double stairsReluctance() {
        return this.stairsReluctance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WheelchairPreferences that = (WheelchairPreferences)o;
        return Double.compare(that.inaccessibleStreetReluctance, this.inaccessibleStreetReluctance) == 0 && Double.compare(that.maxSlope, this.maxSlope) == 0 && Double.compare(that.slopeExceededReluctance, this.slopeExceededReluctance) == 0 && Double.compare(that.stairsReluctance, this.stairsReluctance) == 0 && this.trip.equals(that.trip) && this.stop.equals(that.stop) && this.elevator.equals(that.elevator);
    }

    public int hashCode() {
        return Objects.hash(this.trip, this.stop, this.elevator, this.inaccessibleStreetReluctance, this.maxSlope, this.slopeExceededReluctance, this.stairsReluctance);
    }

    public String toString() {
        return ToStringBuilder.of(WheelchairPreferences.class).addObjOp("trip", (Object)this.trip, (Object)WheelchairPreferences.DEFAULT.trip, i -> i.toString(DEFAULT_COSTS)).addObjOp("stop", (Object)this.stop, (Object)WheelchairPreferences.DEFAULT.stop, i -> i.toString(DEFAULT_COSTS)).addObjOp("elevator", (Object)this.elevator, (Object)WheelchairPreferences.DEFAULT.elevator, i -> i.toString(WheelchairPreferences.DEFAULT.elevator)).addNum("inaccessibleStreetReluctance", (Number)this.inaccessibleStreetReluctance, (Number)WheelchairPreferences.DEFAULT.inaccessibleStreetReluctance).addNum("maxSlope", (Number)this.maxSlope, (Number)WheelchairPreferences.DEFAULT.maxSlope).addNum("slopeExceededReluctance", (Number)this.slopeExceededReluctance, (Number)WheelchairPreferences.DEFAULT.slopeExceededReluctance).addNum("stairsReluctance", (Number)this.stairsReluctance, (Number)WheelchairPreferences.DEFAULT.stairsReluctance).toString();
    }

    public static class Builder {
        private final WheelchairPreferences original;
        private AccessibilityPreferences trip;
        private AccessibilityPreferences stop;
        private AccessibilityPreferences elevator;
        private double inaccessibleStreetReluctance;
        private double maxSlope;
        private double slopeExceededReluctance;
        private double stairsReluctance;

        private Builder(WheelchairPreferences original) {
            this.original = original;
            this.trip = original.trip;
            this.stop = original.stop;
            this.elevator = original.elevator;
            this.inaccessibleStreetReluctance = original.inaccessibleStreetReluctance;
            this.maxSlope = original.maxSlope;
            this.slopeExceededReluctance = original.slopeExceededReluctance;
            this.stairsReluctance = original.stairsReluctance;
        }

        public WheelchairPreferences original() {
            return this.original;
        }

        public Builder withTrip(AccessibilityPreferences trip) {
            this.trip = trip;
            return this;
        }

        public Builder withTrip(Consumer<AccessibilityPreferences.Builder> body) {
            this.trip = this.trip.copyOfWithDefaultCosts(DEFAULT_COSTS).apply(body).build();
            return this;
        }

        public Builder withTripOnlyAccessible() {
            this.trip = AccessibilityPreferences.ofOnlyAccessible();
            return this;
        }

        public Builder withTripCost(int unknownCost, int inaccessibleCost) {
            this.trip = AccessibilityPreferences.ofCost(unknownCost, inaccessibleCost);
            return this;
        }

        public Builder withStop(AccessibilityPreferences stop) {
            this.stop = stop;
            return this;
        }

        public Builder withStop(Consumer<AccessibilityPreferences.Builder> body) {
            this.stop = this.stop.copyOfWithDefaultCosts(DEFAULT_COSTS).apply(body).build();
            return this;
        }

        public Builder withStopOnlyAccessible() {
            this.stop = AccessibilityPreferences.ofOnlyAccessible();
            return this;
        }

        public Builder withStopCost(int unknownCost, int inaccessibleCost) {
            this.stop = AccessibilityPreferences.ofCost(unknownCost, inaccessibleCost);
            return this;
        }

        public Builder withElevator(AccessibilityPreferences elevator) {
            this.elevator = elevator;
            return this;
        }

        public Builder withElevator(Consumer<AccessibilityPreferences.Builder> body) {
            this.elevator = this.elevator.copyOfWithDefaultCosts(DEFAULT_ELEVATOR_PREFERENCES).apply(body).build();
            return this;
        }

        public Builder withElevatorOnlyAccessible() {
            this.elevator = AccessibilityPreferences.ofOnlyAccessible();
            return this;
        }

        public Builder withElevatorCost(int unknownCost, int inaccessibleCost) {
            this.elevator = AccessibilityPreferences.ofCost(unknownCost, inaccessibleCost);
            return this;
        }

        public Builder withInaccessibleStreetReluctance(double inaccessibleStreetReluctance) {
            this.inaccessibleStreetReluctance = inaccessibleStreetReluctance;
            return this;
        }

        public Builder withMaxSlope(double maxSlope) {
            this.maxSlope = maxSlope;
            return this;
        }

        public Builder withSlopeExceededReluctance(double slopeExceededReluctance) {
            this.slopeExceededReluctance = slopeExceededReluctance;
            return this;
        }

        public Builder withStairsReluctance(double stairsReluctance) {
            this.stairsReluctance = stairsReluctance;
            return this;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        public WheelchairPreferences build() {
            WheelchairPreferences value = new WheelchairPreferences(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

