/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.framework.model.Units;
import org.opentripplanner.routing.api.request.preference.EscalatorPreferences;
import org.opentripplanner.utils.lang.DoubleUtils;
import org.opentripplanner.utils.lang.ObjectUtils;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public final class WalkPreferences
implements Serializable {
    public static final WalkPreferences DEFAULT = new WalkPreferences();
    private final double speed;
    private final double reluctance;
    private final Cost boardCost;
    private final double stairsReluctance;
    private final double stairsTimeFactor;
    private final double safetyFactor;
    private final EscalatorPreferences escalator;

    private WalkPreferences() {
        this.speed = 1.33;
        this.reluctance = 2.0;
        this.boardCost = Cost.costOfMinutes(10);
        this.stairsReluctance = 2.0;
        this.stairsTimeFactor = 3.0;
        this.safetyFactor = 1.0;
        this.escalator = EscalatorPreferences.DEFAULT;
    }

    private WalkPreferences(Builder builder) {
        this.speed = Units.speed(builder.speed);
        this.reluctance = Units.reluctance(builder.reluctance);
        this.boardCost = builder.boardCost;
        this.stairsReluctance = Units.reluctance(builder.stairsReluctance);
        this.stairsTimeFactor = Units.reluctance(builder.stairsTimeFactor);
        this.safetyFactor = Units.reluctance(builder.safetyFactor);
        this.escalator = builder.escalator;
    }

    public static Builder of() {
        return new Builder(DEFAULT);
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public double speed() {
        return this.speed;
    }

    public double reluctance() {
        return this.reluctance;
    }

    public int boardCost() {
        return this.boardCost.toSeconds();
    }

    public double stairsReluctance() {
        return this.stairsReluctance;
    }

    public double stairsTimeFactor() {
        return this.stairsTimeFactor;
    }

    public double safetyFactor() {
        return this.safetyFactor;
    }

    public EscalatorPreferences escalator() {
        return this.escalator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WalkPreferences that = (WalkPreferences)o;
        return DoubleUtils.doubleEquals((double)that.speed, (double)this.speed) && DoubleUtils.doubleEquals((double)that.reluctance, (double)this.reluctance) && this.boardCost.equals(that.boardCost) && DoubleUtils.doubleEquals((double)that.stairsReluctance, (double)this.stairsReluctance) && DoubleUtils.doubleEquals((double)that.stairsTimeFactor, (double)this.stairsTimeFactor) && DoubleUtils.doubleEquals((double)that.safetyFactor, (double)this.safetyFactor) && this.escalator.equals(that.escalator);
    }

    public int hashCode() {
        return Objects.hash(this.speed, this.reluctance, this.boardCost, this.stairsReluctance, this.stairsTimeFactor, this.safetyFactor, this.escalator);
    }

    public String toString() {
        return ToStringBuilder.of(WalkPreferences.class).addNum("speed", (Number)this.speed, (Number)WalkPreferences.DEFAULT.speed).addNum("reluctance", (Number)this.reluctance, (Number)WalkPreferences.DEFAULT.reluctance).addObj("boardCost", (Object)this.boardCost, (Object)WalkPreferences.DEFAULT.boardCost).addNum("stairsReluctance", (Number)this.stairsReluctance, (Number)WalkPreferences.DEFAULT.stairsReluctance).addNum("stairsTimeFactor", (Number)this.stairsTimeFactor, (Number)WalkPreferences.DEFAULT.stairsTimeFactor).addNum("safetyFactor", (Number)this.safetyFactor, (Number)WalkPreferences.DEFAULT.safetyFactor).addObj("escalator", (Object)this.escalator, (Object)WalkPreferences.DEFAULT.escalator).toString();
    }

    public static class Builder {
        private final WalkPreferences original;
        private double speed;
        private double reluctance;
        private Cost boardCost;
        private double stairsReluctance;
        private double stairsTimeFactor;
        private double safetyFactor;
        private EscalatorPreferences escalator;

        public Builder(WalkPreferences original) {
            this.original = original;
            this.speed = original.speed;
            this.reluctance = original.reluctance;
            this.boardCost = original.boardCost;
            this.stairsReluctance = original.stairsReluctance;
            this.stairsTimeFactor = original.stairsTimeFactor;
            this.safetyFactor = original.safetyFactor;
            this.escalator = original.escalator;
        }

        public WalkPreferences original() {
            return this.original;
        }

        public double speed() {
            return this.speed;
        }

        public Builder withSpeed(double speed) {
            this.speed = speed;
            return this;
        }

        public double reluctance() {
            return this.reluctance;
        }

        public Builder withReluctance(double reluctance) {
            this.reluctance = reluctance;
            return this;
        }

        public Cost boardCost() {
            return this.boardCost;
        }

        public Builder withBoardCost(int boardCost) {
            this.boardCost = Cost.costOfSeconds(boardCost);
            return this;
        }

        public double stairsReluctance() {
            return this.stairsReluctance;
        }

        public Builder withStairsReluctance(double stairsReluctance) {
            this.stairsReluctance = stairsReluctance;
            return this;
        }

        public double stairsTimeFactor() {
            return this.stairsTimeFactor;
        }

        public Builder withStairsTimeFactor(double stairsTimeFactor) {
            this.stairsTimeFactor = stairsTimeFactor;
            return this;
        }

        public double safetyFactor() {
            return this.safetyFactor;
        }

        public Builder withSafetyFactor(double safetyFactor) {
            this.safetyFactor = safetyFactor < 0.0 ? 0.0 : (safetyFactor > 1.0 ? 1.0 : safetyFactor);
            return this;
        }

        public EscalatorPreferences escalator() {
            return this.escalator;
        }

        public Builder withEscalator(Consumer<EscalatorPreferences.Builder> body) {
            this.escalator = ((EscalatorPreferences)ObjectUtils.ifNotNull((Object)this.escalator, (Object)this.original.escalator)).copyOf().apply(body).build();
            return this;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        public WalkPreferences build() {
            WalkPreferences newObj = new WalkPreferences(this);
            return this.original.equals(newObj) ? this.original : newObj;
        }
    }
}

