/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.framework.model.Units;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class VehicleWalkingPreferences
implements Serializable {
    public static final VehicleWalkingPreferences DEFAULT = new VehicleWalkingPreferences();
    private final double speed;
    private final double reluctance;
    private final Duration mountDismountTime;
    private final Cost mountDismountCost;
    private final double stairsReluctance;

    private VehicleWalkingPreferences() {
        this.speed = 1.33;
        this.reluctance = 5.0;
        this.mountDismountTime = Duration.ZERO;
        this.mountDismountCost = Cost.ZERO;
        this.stairsReluctance = 10.0;
    }

    private VehicleWalkingPreferences(Builder builder) {
        this.speed = Units.speed(builder.speed);
        this.reluctance = Units.reluctance(builder.reluctance);
        this.mountDismountTime = Duration.ofSeconds(Units.duration(builder.mountDismountTime));
        this.mountDismountCost = Cost.costOfSeconds(builder.mountDismountCost);
        this.stairsReluctance = Units.reluctance(builder.stairsReluctance);
    }

    public static Builder of() {
        return new Builder(DEFAULT);
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public double speed() {
        return this.speed;
    }

    public double reluctance() {
        return this.reluctance;
    }

    public Duration mountDismountTime() {
        return this.mountDismountTime;
    }

    public Cost mountDismountCost() {
        return this.mountDismountCost;
    }

    public double stairsReluctance() {
        return this.stairsReluctance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VehicleWalkingPreferences that = (VehicleWalkingPreferences)o;
        return this.speed == that.speed && this.reluctance == that.reluctance && Objects.equals(this.mountDismountTime, that.mountDismountTime) && Objects.equals(this.mountDismountCost, that.mountDismountCost) && this.stairsReluctance == that.stairsReluctance;
    }

    public int hashCode() {
        return Objects.hash(this.speed, this.reluctance, this.mountDismountTime, this.mountDismountCost, this.stairsReluctance);
    }

    public String toString() {
        return ToStringBuilder.of(VehicleWalkingPreferences.class).addNum("speed", (Number)this.speed, (Number)VehicleWalkingPreferences.DEFAULT.speed).addNum("reluctance", (Number)this.reluctance, (Number)VehicleWalkingPreferences.DEFAULT.reluctance).addObj("mountDismountTime", (Object)this.mountDismountTime, (Object)VehicleWalkingPreferences.DEFAULT.mountDismountTime).addObj("mountDismountCost", (Object)this.mountDismountCost, (Object)VehicleWalkingPreferences.DEFAULT.mountDismountCost).addNum("stairsReluctance", (Number)this.stairsReluctance, (Number)VehicleWalkingPreferences.DEFAULT.stairsReluctance).toString();
    }

    public static class Builder {
        private final VehicleWalkingPreferences original;
        private double speed;
        private double reluctance;
        private int mountDismountTime;
        private int mountDismountCost;
        private double stairsReluctance;

        private Builder(VehicleWalkingPreferences original) {
            this.original = original;
            this.speed = original.speed;
            this.reluctance = original.reluctance;
            this.mountDismountTime = (int)original.mountDismountTime.toSeconds();
            this.mountDismountCost = original.mountDismountCost.toSeconds();
            this.stairsReluctance = original.stairsReluctance;
        }

        public Builder withSpeed(double speed) {
            this.speed = speed;
            return this;
        }

        public Builder withReluctance(double reluctance) {
            this.reluctance = reluctance;
            return this;
        }

        public Builder withMountDismountTime(Duration mountDismountTime) {
            this.mountDismountTime = (int)mountDismountTime.toSeconds();
            return this;
        }

        public Builder withMountDismountTime(int mountDismountTime) {
            this.mountDismountTime = mountDismountTime;
            return this;
        }

        public Builder withMountDismountCost(int mountDismountCost) {
            this.mountDismountCost = mountDismountCost;
            return this;
        }

        public Builder withStairsReluctance(double stairsReluctance) {
            this.stairsReluctance = stairsReluctance;
            return this;
        }

        public VehicleWalkingPreferences original() {
            return this.original;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        public VehicleWalkingPreferences build() {
            VehicleWalkingPreferences newObj = new VehicleWalkingPreferences(this);
            return this.original.equals(newObj) ? this.original : newObj;
        }
    }
}

