/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.framework.model.Units;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public final class VehicleRentalPreferences
implements Serializable {
    public static final VehicleRentalPreferences DEFAULT = new VehicleRentalPreferences();
    private final Duration pickupTime;
    private final Cost pickupCost;
    private final Duration dropOffTime;
    private final Cost dropOffCost;
    private final boolean useAvailabilityInformation;
    private final Cost arrivingInRentalVehicleAtDestinationCost;
    private final boolean allowArrivingInRentedVehicleAtDestination;
    private final Set<String> allowedNetworks;
    private final Set<String> bannedNetworks;

    private VehicleRentalPreferences() {
        this.pickupTime = Duration.ofMinutes(1L);
        this.pickupCost = Cost.costOfMinutes(2);
        this.dropOffTime = Duration.ofSeconds(30L);
        this.dropOffCost = Cost.costOfSeconds(30);
        this.useAvailabilityInformation = false;
        this.arrivingInRentalVehicleAtDestinationCost = Cost.costOfSeconds(0);
        this.allowArrivingInRentedVehicleAtDestination = false;
        this.allowedNetworks = Set.of();
        this.bannedNetworks = Set.of();
    }

    private VehicleRentalPreferences(Builder builder) {
        this.pickupTime = Duration.ofSeconds(Units.duration(builder.pickupTime));
        this.pickupCost = builder.pickupCost;
        this.dropOffTime = Duration.ofSeconds(Units.duration(builder.dropOffTime));
        this.dropOffCost = builder.dropOffCost;
        this.useAvailabilityInformation = builder.useAvailabilityInformation;
        this.arrivingInRentalVehicleAtDestinationCost = builder.arrivingInRentalVehicleAtDestinationCost;
        this.allowArrivingInRentedVehicleAtDestination = builder.allowArrivingInRentedVehicleAtDestination;
        this.allowedNetworks = builder.allowedNetworks;
        this.bannedNetworks = builder.bannedNetworks;
    }

    public static Builder of() {
        return DEFAULT.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public Duration pickupTime() {
        return this.pickupTime;
    }

    public Cost pickupCost() {
        return this.pickupCost;
    }

    public Duration dropOffTime() {
        return this.dropOffTime;
    }

    public Cost dropOffCost() {
        return this.dropOffCost;
    }

    public boolean useAvailabilityInformation() {
        return this.useAvailabilityInformation;
    }

    public Cost arrivingInRentalVehicleAtDestinationCost() {
        return this.arrivingInRentalVehicleAtDestinationCost;
    }

    public boolean allowArrivingInRentedVehicleAtDestination() {
        return this.allowArrivingInRentedVehicleAtDestination;
    }

    public Set<String> allowedNetworks() {
        return this.allowedNetworks;
    }

    public Set<String> bannedNetworks() {
        return this.bannedNetworks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VehicleRentalPreferences that = (VehicleRentalPreferences)o;
        return Objects.equals(this.pickupTime, that.pickupTime) && Objects.equals(this.pickupCost, that.pickupCost) && Objects.equals(this.dropOffTime, that.dropOffTime) && Objects.equals(this.dropOffCost, that.dropOffCost) && this.useAvailabilityInformation == that.useAvailabilityInformation && Objects.equals(that.arrivingInRentalVehicleAtDestinationCost, this.arrivingInRentalVehicleAtDestinationCost) && this.allowArrivingInRentedVehicleAtDestination == that.allowArrivingInRentedVehicleAtDestination && this.allowedNetworks.equals(that.allowedNetworks) && this.bannedNetworks.equals(that.bannedNetworks);
    }

    public int hashCode() {
        return Objects.hash(this.pickupTime, this.pickupCost, this.dropOffTime, this.dropOffCost, this.useAvailabilityInformation, this.arrivingInRentalVehicleAtDestinationCost, this.allowArrivingInRentedVehicleAtDestination, this.allowedNetworks, this.bannedNetworks);
    }

    public String toString() {
        return ToStringBuilder.of(VehicleRentalPreferences.class).addDuration("pickupTime", this.pickupTime, VehicleRentalPreferences.DEFAULT.pickupTime).addObj("pickupCost", (Object)this.pickupCost, (Object)VehicleRentalPreferences.DEFAULT.pickupCost).addDuration("dropOffTime", this.dropOffTime, VehicleRentalPreferences.DEFAULT.dropOffTime).addObj("dropOffCost", (Object)this.dropOffCost, (Object)VehicleRentalPreferences.DEFAULT.dropOffCost).addBoolIfTrue("useAvailabilityInformation", Boolean.valueOf(this.useAvailabilityInformation)).addObj("arrivingInRentalVehicleAtDestinationCost", (Object)this.arrivingInRentalVehicleAtDestinationCost, (Object)VehicleRentalPreferences.DEFAULT.arrivingInRentalVehicleAtDestinationCost).addBoolIfTrue("allowArrivingInRentedVehicleAtDestination", Boolean.valueOf(this.allowArrivingInRentedVehicleAtDestination)).addCol("allowedNetworks", this.allowedNetworks, VehicleRentalPreferences.DEFAULT.allowedNetworks).addCol("bannedNetworks", this.bannedNetworks, VehicleRentalPreferences.DEFAULT.bannedNetworks).toString();
    }

    public static class Builder {
        private final VehicleRentalPreferences original;
        private int pickupTime;
        private Cost pickupCost;
        private int dropOffTime;
        private Cost dropOffCost;
        private boolean useAvailabilityInformation;
        private Cost arrivingInRentalVehicleAtDestinationCost;
        private boolean allowArrivingInRentedVehicleAtDestination;
        private Set<String> allowedNetworks;
        private Set<String> bannedNetworks;

        private Builder(VehicleRentalPreferences original) {
            this.original = original;
            this.pickupTime = (int)original.pickupTime.toSeconds();
            this.pickupCost = original.pickupCost;
            this.dropOffTime = (int)original.dropOffTime.toSeconds();
            this.dropOffCost = original.dropOffCost;
            this.useAvailabilityInformation = original.useAvailabilityInformation;
            this.arrivingInRentalVehicleAtDestinationCost = original.arrivingInRentalVehicleAtDestinationCost;
            this.allowArrivingInRentedVehicleAtDestination = original.allowArrivingInRentedVehicleAtDestination;
            this.allowedNetworks = original.allowedNetworks;
            this.bannedNetworks = original.bannedNetworks;
        }

        public VehicleRentalPreferences original() {
            return this.original;
        }

        public Builder withPickupTime(int pickupTime) {
            this.pickupTime = pickupTime;
            return this;
        }

        public Builder withPickupTime(Duration pickupTime) {
            this.pickupTime = (int)pickupTime.toSeconds();
            return this;
        }

        public Builder withPickupCost(int pickupCost) {
            this.pickupCost = Cost.costOfSeconds(pickupCost);
            return this;
        }

        public Builder withDropOffTime(int dropOffTime) {
            this.dropOffTime = dropOffTime;
            return this;
        }

        public Builder withDropOffTime(Duration dropOffTime) {
            this.dropOffTime = (int)dropOffTime.toSeconds();
            return this;
        }

        public Builder withDropOffCost(int dropOffCost) {
            this.dropOffCost = Cost.costOfSeconds(dropOffCost);
            return this;
        }

        public Builder withUseAvailabilityInformation(boolean useAvailabilityInformation) {
            this.useAvailabilityInformation = useAvailabilityInformation;
            return this;
        }

        public Builder withArrivingInRentalVehicleAtDestinationCost(int arrivingInRentalVehicleAtDestinationCost) {
            this.arrivingInRentalVehicleAtDestinationCost = Cost.costOfSeconds(arrivingInRentalVehicleAtDestinationCost);
            return this;
        }

        public Builder withAllowArrivingInRentedVehicleAtDestination(boolean allowArrivingInRentedVehicleAtDestination) {
            this.allowArrivingInRentedVehicleAtDestination = allowArrivingInRentedVehicleAtDestination;
            return this;
        }

        public Builder withAllowedNetworks(Set<String> allowedNetworks) {
            this.allowedNetworks = allowedNetworks;
            return this;
        }

        public Builder withBannedNetworks(Set<String> bannedNetworks) {
            this.bannedNetworks = bannedNetworks;
            return this;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        public VehicleRentalPreferences build() {
            VehicleRentalPreferences value = new VehicleRentalPreferences(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

