/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.routing.api.request.preference.filter.VehicleParkingFilter;
import org.opentripplanner.routing.api.request.preference.filter.VehicleParkingSelect;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public final class VehicleParkingPreferences
implements Serializable {
    public static final VehicleParkingPreferences DEFAULT = new VehicleParkingPreferences();
    private final Cost unpreferredVehicleParkingTagCost;
    private final VehicleParkingFilter filter;
    private final VehicleParkingFilter preferred;
    private final Duration time;
    private final Cost cost;

    private VehicleParkingPreferences() {
        this.unpreferredVehicleParkingTagCost = Cost.costOfMinutes(5);
        this.filter = VehicleParkingFilter.empty();
        this.preferred = VehicleParkingFilter.empty();
        this.time = Duration.ofMinutes(1L);
        this.cost = Cost.costOfMinutes(2);
    }

    private VehicleParkingPreferences(Builder builder) {
        this.unpreferredVehicleParkingTagCost = builder.unpreferredVehicleParkingTagCost;
        this.filter = new VehicleParkingFilter(builder.bannedVehicleParkingTags, builder.requiredVehicleParkingTags);
        this.preferred = new VehicleParkingFilter(builder.notPreferredVehicleParkingTags, builder.preferredVehicleParkingTags);
        this.time = builder.time;
        this.cost = builder.cost;
    }

    public static Builder of() {
        return new Builder(DEFAULT);
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public Cost unpreferredVehicleParkingTagCost() {
        return this.unpreferredVehicleParkingTagCost;
    }

    public VehicleParkingFilter filter() {
        return this.filter;
    }

    public VehicleParkingFilter preferred() {
        return this.preferred;
    }

    public Duration time() {
        return this.time;
    }

    public Cost cost() {
        return this.cost;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VehicleParkingPreferences that = (VehicleParkingPreferences)o;
        return Objects.equals(this.unpreferredVehicleParkingTagCost, that.unpreferredVehicleParkingTagCost) && Objects.equals(this.filter, that.filter) && Objects.equals(this.preferred, that.preferred) && Objects.equals(this.cost, that.cost) && Objects.equals(this.time, that.time);
    }

    public int hashCode() {
        return Objects.hash(this.unpreferredVehicleParkingTagCost, this.filter, this.preferred, this.cost, this.time);
    }

    public String toString() {
        return ToStringBuilder.of(VehicleParkingPreferences.class).addObj("unpreferredVehicleParkingTagCost", (Object)this.unpreferredVehicleParkingTagCost, (Object)VehicleParkingPreferences.DEFAULT.unpreferredVehicleParkingTagCost).addObj("filter", (Object)this.filter, (Object)VehicleParkingPreferences.DEFAULT.filter).addObj("preferred", (Object)this.preferred, (Object)VehicleParkingPreferences.DEFAULT.preferred).addObj("cost", (Object)this.cost, (Object)VehicleParkingPreferences.DEFAULT.cost).addObj("time", (Object)this.time, (Object)VehicleParkingPreferences.DEFAULT.time).toString();
    }

    public static class Builder {
        private final VehicleParkingPreferences original;
        private Cost unpreferredVehicleParkingTagCost;
        private List<VehicleParkingSelect> bannedVehicleParkingTags;
        private List<VehicleParkingSelect> requiredVehicleParkingTags;
        private List<VehicleParkingSelect> preferredVehicleParkingTags;
        private List<VehicleParkingSelect> notPreferredVehicleParkingTags;
        private Cost cost;
        private Duration time;

        private Builder(VehicleParkingPreferences original) {
            this.original = original;
            this.unpreferredVehicleParkingTagCost = original.unpreferredVehicleParkingTagCost;
            this.bannedVehicleParkingTags = original.filter.not();
            this.requiredVehicleParkingTags = original.filter.select();
            this.preferredVehicleParkingTags = original.preferred.select();
            this.notPreferredVehicleParkingTags = original.preferred.not();
            this.cost = original.cost;
            this.time = original.time;
        }

        public Builder withUnpreferredVehicleParkingTagCost(int cost) {
            this.unpreferredVehicleParkingTagCost = Cost.costOfSeconds(cost);
            return this;
        }

        public Builder withBannedVehicleParkingTags(Set<String> bannedVehicleParkingTags) {
            this.bannedVehicleParkingTags = List.of(new VehicleParkingSelect.TagsSelect(bannedVehicleParkingTags));
            return this;
        }

        public Builder withRequiredVehicleParkingTags(Set<String> requiredVehicleParkingTags) {
            this.requiredVehicleParkingTags = List.of(new VehicleParkingSelect.TagsSelect(requiredVehicleParkingTags));
            return this;
        }

        public Builder withPreferredVehicleParkingTags(Set<String> preferredVehicleParkingTags) {
            this.preferredVehicleParkingTags = List.of(new VehicleParkingSelect.TagsSelect(preferredVehicleParkingTags));
            return this;
        }

        public Builder withNotPreferredVehicleParkingTags(Set<String> notPreferredVehicleParkingTags) {
            this.notPreferredVehicleParkingTags = List.of(new VehicleParkingSelect.TagsSelect(notPreferredVehicleParkingTags));
            return this;
        }

        public Builder withCost(int cost) {
            this.cost = Cost.costOfSeconds(cost);
            return this;
        }

        public Builder withTime(int seconds) {
            this.time = Duration.ofSeconds(seconds);
            return this;
        }

        public Builder withTime(Duration duration) {
            this.time = duration;
            return this;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        public VehicleParkingPreferences build() {
            VehicleParkingPreferences newObj = new VehicleParkingPreferences(this);
            return this.original.equals(newObj) ? this.original : newObj;
        }
    }
}

