/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.framework.model.Units;
import org.opentripplanner.routing.algorithm.transferoptimization.api.TransferOptimizationParameters;
import org.opentripplanner.routing.api.request.preference.TransferOptimizationPreferences;
import org.opentripplanner.utils.lang.DoubleUtils;
import org.opentripplanner.utils.time.DurationUtils;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public final class TransferPreferences
implements Serializable {
    public static final TransferPreferences DEFAULT = new TransferPreferences();
    private static final int MAX_NUMBER_OF_TRANSFERS = 30;
    private final Cost cost;
    private final Duration slack;
    private final double waitReluctance;
    private final int maxTransfers;
    private final int maxAdditionalTransfers;
    private final TransferOptimizationParameters optimization;
    private final Cost nonpreferredCost;

    private TransferPreferences() {
        this.cost = Cost.ZERO;
        this.slack = Duration.ofMinutes(2L);
        this.waitReluctance = 1.0;
        this.maxTransfers = 12;
        this.maxAdditionalTransfers = 5;
        this.optimization = TransferOptimizationPreferences.DEFAULT;
        this.nonpreferredCost = Cost.costOfMinutes(3);
    }

    private TransferPreferences(Builder builder) {
        this.cost = builder.cost;
        this.slack = DurationUtils.requireNonNegative((Duration)builder.slack);
        this.waitReluctance = Units.reluctance(builder.waitReluctance);
        this.maxTransfers = Units.count(builder.maxTransfers, 30);
        this.maxAdditionalTransfers = Units.count(builder.maxAdditionalTransfers, 30);
        this.optimization = Objects.requireNonNull(builder.optimization);
        this.nonpreferredCost = builder.nonpreferredCost;
    }

    public static Builder of() {
        return DEFAULT.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public int cost() {
        return this.cost.toSeconds();
    }

    public Duration slack() {
        return this.slack;
    }

    public double waitReluctance() {
        return this.waitReluctance;
    }

    public Integer maxTransfers() {
        return this.maxTransfers;
    }

    public Integer maxAdditionalTransfers() {
        return this.maxAdditionalTransfers;
    }

    public TransferOptimizationParameters optimization() {
        return this.optimization;
    }

    @Deprecated
    public int nonpreferredCost() {
        return this.nonpreferredCost.toSeconds();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferPreferences that = (TransferPreferences)o;
        return this.cost.equals(that.cost) && this.slack.equals(that.slack) && DoubleUtils.doubleEquals((double)that.waitReluctance, (double)this.waitReluctance) && this.maxTransfers == that.maxTransfers && this.maxAdditionalTransfers == that.maxAdditionalTransfers && this.optimization.equals(that.optimization) && this.nonpreferredCost.equals(that.nonpreferredCost);
    }

    public int hashCode() {
        return Objects.hash(this.cost, this.slack, this.waitReluctance, this.maxTransfers, this.maxAdditionalTransfers, this.optimization, this.nonpreferredCost);
    }

    public String toString() {
        return ToStringBuilder.of(TransferPreferences.class).addObj("cost", (Object)this.cost, (Object)TransferPreferences.DEFAULT.cost).addDuration("slack", this.slack, TransferPreferences.DEFAULT.slack).addNum("waitReluctance", (Number)this.waitReluctance, (Number)TransferPreferences.DEFAULT.waitReluctance).addNum("maxTransfers", (Number)this.maxTransfers, (Number)TransferPreferences.DEFAULT.maxTransfers).addNum("maxAdditionalTransfers", (Number)this.maxAdditionalTransfers, (Number)TransferPreferences.DEFAULT.maxAdditionalTransfers).addObj("optimization", (Object)this.optimization, (Object)TransferPreferences.DEFAULT.optimization).addObj("nonpreferredCost", (Object)this.nonpreferredCost, (Object)TransferPreferences.DEFAULT.nonpreferredCost).toString();
    }

    public static class Builder {
        private final TransferPreferences original;
        private Cost cost;
        private Duration slack;
        private Integer maxTransfers;
        private Integer maxAdditionalTransfers;
        private double waitReluctance;
        private TransferOptimizationParameters optimization;
        private Cost nonpreferredCost;

        public Builder(TransferPreferences original) {
            this.original = original;
            this.cost = original.cost;
            this.slack = original.slack;
            this.maxTransfers = original.maxTransfers;
            this.maxAdditionalTransfers = original.maxAdditionalTransfers;
            this.waitReluctance = original.waitReluctance;
            this.optimization = original.optimization;
            this.nonpreferredCost = original.nonpreferredCost;
        }

        public TransferPreferences original() {
            return this.original;
        }

        public Builder withCost(int cost) {
            this.cost = Cost.costOfSeconds(cost);
            return this;
        }

        public Builder withSlackSec(Number seconds) {
            return this.withSlack(Duration.ofSeconds(seconds.longValue()));
        }

        public Builder withSlack(Duration slack) {
            this.slack = slack;
            return this;
        }

        public Builder withNonpreferredCost(int nonpreferredCost) {
            this.nonpreferredCost = Cost.costOfSeconds(nonpreferredCost);
            return this;
        }

        public Builder withWaitReluctance(double waitReluctance) {
            this.waitReluctance = waitReluctance;
            return this;
        }

        public Builder withOptimization(TransferOptimizationParameters optimization) {
            this.optimization = optimization;
            return this;
        }

        public Builder withMaxTransfers(Integer maxTransfers) {
            this.maxTransfers = maxTransfers;
            return this;
        }

        public Builder withMaxAdditionalTransfers(Integer maxAdditionalTransfers) {
            this.maxAdditionalTransfers = maxAdditionalTransfers;
            return this;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        TransferPreferences build() {
            TransferPreferences value = new TransferPreferences(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

