/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.util.Objects;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.framework.model.Units;
import org.opentripplanner.routing.algorithm.transferoptimization.api.TransferOptimizationParameters;
import org.opentripplanner.utils.lang.DoubleUtils;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public final class TransferOptimizationPreferences
implements Serializable,
TransferOptimizationParameters {
    private final boolean optimizeTransferWaitTime;
    private final double minSafeWaitTimeFactor;
    private final double backTravelWaitTimeFactor;
    private final double extraStopBoardAlightCostsFactor;
    public static final TransferOptimizationPreferences DEFAULT = new TransferOptimizationPreferences();

    private TransferOptimizationPreferences() {
        this.optimizeTransferWaitTime = true;
        this.minSafeWaitTimeFactor = 5.0;
        this.backTravelWaitTimeFactor = 1.0;
        this.extraStopBoardAlightCostsFactor = 0.0;
    }

    private TransferOptimizationPreferences(Builder builder) {
        this.optimizeTransferWaitTime = builder.optimizeTransferWaitTime;
        this.minSafeWaitTimeFactor = Units.reluctance(builder.minSafeWaitTimeFactor);
        this.backTravelWaitTimeFactor = Units.reluctance(builder.backTravelWaitTimeFactor);
        this.extraStopBoardAlightCostsFactor = Units.reluctance(builder.extraStopBoardAlightCostsFactor);
    }

    public static Builder of() {
        return DEFAULT.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    @Override
    public boolean optimizeTransferWaitTime() {
        return this.optimizeTransferWaitTime;
    }

    @Override
    public double minSafeWaitTimeFactor() {
        return this.minSafeWaitTimeFactor;
    }

    @Override
    public double backTravelWaitTimeFactor() {
        return this.backTravelWaitTimeFactor;
    }

    @Override
    public double extraStopBoardAlightCostsFactor() {
        return this.extraStopBoardAlightCostsFactor;
    }

    @Override
    public boolean optimizeTransferPriority() {
        return OTPFeature.TransferConstraints.isOn();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferOptimizationPreferences that = (TransferOptimizationPreferences)o;
        return this.optimizeTransferWaitTime == that.optimizeTransferWaitTime && DoubleUtils.doubleEquals((double)that.minSafeWaitTimeFactor, (double)this.minSafeWaitTimeFactor) && DoubleUtils.doubleEquals((double)that.backTravelWaitTimeFactor, (double)this.backTravelWaitTimeFactor) && DoubleUtils.doubleEquals((double)that.extraStopBoardAlightCostsFactor, (double)this.extraStopBoardAlightCostsFactor);
    }

    public int hashCode() {
        return Objects.hash(this.optimizeTransferWaitTime, this.minSafeWaitTimeFactor, this.backTravelWaitTimeFactor, this.extraStopBoardAlightCostsFactor);
    }

    public String toString() {
        return ToStringBuilder.of(TransferOptimizationPreferences.class).addBoolIfTrue("skipOptimizeWaitTime", Boolean.valueOf(!this.optimizeTransferWaitTime)).addNum("minSafeWaitTimeFactor", (Number)this.minSafeWaitTimeFactor, (Number)TransferOptimizationPreferences.DEFAULT.minSafeWaitTimeFactor).addNum("backTravelWaitTimeFactor", (Number)this.backTravelWaitTimeFactor, (Number)TransferOptimizationPreferences.DEFAULT.backTravelWaitTimeFactor).addNum("extraStopBoardAlightCostsFactor", (Number)this.extraStopBoardAlightCostsFactor, (Number)TransferOptimizationPreferences.DEFAULT.extraStopBoardAlightCostsFactor).toString();
    }

    public static class Builder {
        private final TransferOptimizationPreferences original;
        private boolean optimizeTransferWaitTime;
        private double minSafeWaitTimeFactor;
        private double backTravelWaitTimeFactor;
        private double extraStopBoardAlightCostsFactor;

        public Builder(TransferOptimizationPreferences original) {
            this.original = original;
            this.optimizeTransferWaitTime = original.optimizeTransferWaitTime;
            this.minSafeWaitTimeFactor = original.minSafeWaitTimeFactor;
            this.backTravelWaitTimeFactor = original.backTravelWaitTimeFactor;
            this.extraStopBoardAlightCostsFactor = original.extraStopBoardAlightCostsFactor;
        }

        public Builder withOptimizeTransferWaitTime(boolean optimizeTransferWaitTime) {
            this.optimizeTransferWaitTime = optimizeTransferWaitTime;
            return this;
        }

        public Builder withMinSafeWaitTimeFactor(double minSafeWaitTimeFactor) {
            this.minSafeWaitTimeFactor = minSafeWaitTimeFactor;
            return this;
        }

        public Builder withBackTravelWaitTimeFactor(double backTravelWaitTimeFactor) {
            this.backTravelWaitTimeFactor = backTravelWaitTimeFactor;
            return this;
        }

        public Builder withExtraStopBoardAlightCostsFactor(double extraStopBoardAlightCostsFactor) {
            this.extraStopBoardAlightCostsFactor = extraStopBoardAlightCostsFactor;
            return this;
        }

        public TransferOptimizationPreferences build() {
            TransferOptimizationPreferences value = new TransferOptimizationPreferences(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

