/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.opentripplanner.ext.dataoverlay.api.DataOverlayParameters;
import org.opentripplanner.routing.api.request.RoutingTag;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class SystemPreferences
implements Serializable {
    public static final SystemPreferences DEFAULT = new SystemPreferences();
    private final Set<RoutingTag> tags;
    private final DataOverlayParameters dataOverlay;
    private final boolean geoidElevation;
    private final Duration maxJourneyDuration;

    private SystemPreferences() {
        this.tags = Set.of();
        this.dataOverlay = null;
        this.geoidElevation = false;
        this.maxJourneyDuration = Duration.ofHours(24L);
    }

    private SystemPreferences(Builder builder) {
        this.tags = Set.copyOf(builder.tags);
        this.dataOverlay = builder.dataOverlay;
        this.geoidElevation = builder.geoidElevation;
        this.maxJourneyDuration = Objects.requireNonNull(builder.maxJourneyDuration);
    }

    public static Builder of() {
        return DEFAULT.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public Set<RoutingTag> tags() {
        return this.tags;
    }

    public DataOverlayParameters dataOverlay() {
        return this.dataOverlay;
    }

    public boolean geoidElevation() {
        return this.geoidElevation;
    }

    public Duration maxJourneyDuration() {
        return this.maxJourneyDuration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemPreferences that = (SystemPreferences)o;
        return this.geoidElevation == that.geoidElevation && this.tags.equals(that.tags) && Objects.equals(this.dataOverlay, that.dataOverlay) && this.maxJourneyDuration.equals(that.maxJourneyDuration);
    }

    public int hashCode() {
        return Objects.hash(this.tags, this.dataOverlay, this.geoidElevation, this.maxJourneyDuration);
    }

    public String toString() {
        return ToStringBuilder.of(SystemPreferences.class).addCol("tags", this.tags, SystemPreferences.DEFAULT.tags).addObj("dataOverlay", (Object)this.dataOverlay, (Object)SystemPreferences.DEFAULT.dataOverlay).addBoolIfTrue("geoidElevation", Boolean.valueOf(this.geoidElevation)).addDuration("maxJourneyDuration", this.maxJourneyDuration, SystemPreferences.DEFAULT.maxJourneyDuration).toString();
    }

    public static class Builder {
        private final SystemPreferences original;
        private final List<RoutingTag> tags = new ArrayList<RoutingTag>();
        private DataOverlayParameters dataOverlay;
        private boolean geoidElevation;
        private Duration maxJourneyDuration;

        public Builder(SystemPreferences original) {
            this.original = original;
            this.tags.addAll(original.tags);
            this.dataOverlay = original.dataOverlay;
            this.geoidElevation = original.geoidElevation;
            this.maxJourneyDuration = original.maxJourneyDuration;
        }

        public SystemPreferences original() {
            return this.original;
        }

        public Builder addTags(Collection<RoutingTag> tags) {
            this.tags.addAll(tags);
            return this;
        }

        public Builder withDataOverlay(DataOverlayParameters dataOverlay) {
            this.dataOverlay = dataOverlay;
            return this;
        }

        public Builder withGeoidElevation(boolean geoidElevation) {
            this.geoidElevation = geoidElevation;
            return this;
        }

        public Builder withMaxJourneyDuration(Duration maxJourneyDuration) {
            this.maxJourneyDuration = maxJourneyDuration;
            return this;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        public SystemPreferences build() {
            SystemPreferences value = new SystemPreferences(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

