/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.framework.model.Units;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.framework.DurationForEnum;
import org.opentripplanner.routing.api.request.preference.AccessEgressPreferences;
import org.opentripplanner.routing.api.request.preference.ElevatorPreferences;
import org.opentripplanner.street.search.intersection_model.DrivingDirection;
import org.opentripplanner.street.search.intersection_model.IntersectionTraversalModel;
import org.opentripplanner.utils.lang.DoubleUtils;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public final class StreetPreferences
implements Serializable {
    public static StreetPreferences DEFAULT = new StreetPreferences();
    private final double turnReluctance;
    private final DrivingDirection drivingDirection;
    private final ElevatorPreferences elevator;
    private final AccessEgressPreferences accessEgress;
    private final IntersectionTraversalModel intersectionTraversalModel;
    private final DurationForEnum<StreetMode> maxDirectDuration;
    private final Duration routingTimeout;

    private StreetPreferences() {
        this.turnReluctance = 1.0;
        this.drivingDirection = DrivingDirection.RIGHT;
        this.elevator = ElevatorPreferences.DEFAULT;
        this.accessEgress = AccessEgressPreferences.DEFAULT;
        this.intersectionTraversalModel = IntersectionTraversalModel.SIMPLE;
        this.maxDirectDuration = StreetPreferences.durationForStreetModeOf(Duration.ofHours(4L));
        this.routingTimeout = Duration.ofSeconds(5L);
    }

    private StreetPreferences(Builder builder) {
        this.turnReluctance = Units.reluctance(builder.turnReluctance);
        this.drivingDirection = Objects.requireNonNull(builder.drivingDirection);
        this.elevator = Objects.requireNonNull(builder.elevator);
        this.accessEgress = Objects.requireNonNull(builder.accessEgress);
        this.intersectionTraversalModel = Objects.requireNonNull(builder.intersectionTraversalModel);
        this.maxDirectDuration = Objects.requireNonNull(builder.maxDirectDuration);
        this.routingTimeout = Objects.requireNonNull(builder.routingTimeout);
    }

    public static Builder of() {
        return DEFAULT.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public double turnReluctance() {
        return this.turnReluctance;
    }

    public DrivingDirection drivingDirection() {
        return this.drivingDirection;
    }

    public ElevatorPreferences elevator() {
        return this.elevator;
    }

    public AccessEgressPreferences accessEgress() {
        return this.accessEgress;
    }

    public IntersectionTraversalModel intersectionTraversalModel() {
        return this.intersectionTraversalModel;
    }

    public DurationForEnum<StreetMode> maxDirectDuration() {
        return this.maxDirectDuration;
    }

    public Duration routingTimeout() {
        return this.routingTimeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreetPreferences that = (StreetPreferences)o;
        return DoubleUtils.doubleEquals((double)that.turnReluctance, (double)this.turnReluctance) && this.drivingDirection == that.drivingDirection && this.elevator.equals(that.elevator) && this.routingTimeout.equals(that.routingTimeout) && this.intersectionTraversalModel == that.intersectionTraversalModel && this.maxDirectDuration.equals(that.maxDirectDuration) && this.accessEgress.equals(that.accessEgress);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.turnReluctance, this.drivingDirection, this.elevator, this.accessEgress, this.routingTimeout, this.intersectionTraversalModel, this.maxDirectDuration});
    }

    public String toString() {
        return ToStringBuilder.of(StreetPreferences.class).addNum("turnReluctance", (Number)this.turnReluctance, (Number)StreetPreferences.DEFAULT.turnReluctance).addEnum("drivingDirection", (Enum)this.drivingDirection, (Enum)StreetPreferences.DEFAULT.drivingDirection).addDuration("routingTimeout", this.routingTimeout, DEFAULT.routingTimeout()).addObj("elevator", (Object)this.elevator, (Object)StreetPreferences.DEFAULT.elevator).addObj("intersectionTraversalModel", (Object)this.intersectionTraversalModel, (Object)StreetPreferences.DEFAULT.intersectionTraversalModel).addObj("accessEgress", (Object)this.accessEgress, (Object)StreetPreferences.DEFAULT.accessEgress).addObj("maxDirectDuration", this.maxDirectDuration, StreetPreferences.DEFAULT.maxDirectDuration).toString();
    }

    private static DurationForEnum<StreetMode> durationForStreetModeOf(Duration defaultValue) {
        return DurationForEnum.of(StreetMode.class).withDefault(defaultValue).build();
    }

    public static class Builder {
        private final StreetPreferences original;
        private double turnReluctance;
        private DrivingDirection drivingDirection;
        private ElevatorPreferences elevator;
        private IntersectionTraversalModel intersectionTraversalModel;
        private DurationForEnum<StreetMode> maxDirectDuration;
        private Duration routingTimeout;
        private AccessEgressPreferences accessEgress;

        public Builder(StreetPreferences original) {
            this.original = original;
            this.turnReluctance = original.turnReluctance;
            this.drivingDirection = original.drivingDirection;
            this.elevator = original.elevator;
            this.intersectionTraversalModel = original.intersectionTraversalModel;
            this.accessEgress = original.accessEgress;
            this.maxDirectDuration = original.maxDirectDuration;
            this.routingTimeout = original.routingTimeout;
        }

        public StreetPreferences original() {
            return this.original;
        }

        public Builder withTurnReluctance(double turnReluctance) {
            this.turnReluctance = turnReluctance;
            return this;
        }

        public Builder withDrivingDirection(DrivingDirection drivingDirection) {
            this.drivingDirection = drivingDirection;
            return this;
        }

        public Builder withElevator(Consumer<ElevatorPreferences.Builder> body) {
            this.elevator = this.elevator.copyOf().apply(body).build();
            return this;
        }

        public Builder withAccessEgress(Consumer<AccessEgressPreferences.Builder> body) {
            this.accessEgress = this.accessEgress.copyOf().apply(body).build();
            return this;
        }

        public Builder withIntersectionTraversalModel(IntersectionTraversalModel model) {
            this.intersectionTraversalModel = model;
            return this;
        }

        public Builder withMaxDirectDuration(Consumer<DurationForEnum.Builder<StreetMode>> body) {
            this.maxDirectDuration = this.maxDirectDuration.copyOf().apply(body).build();
            return this;
        }

        public Builder withMaxDirectDuration(Duration defaultValue, Map<StreetMode, Duration> values) {
            return this.withMaxDirectDuration(b -> b.withDefault(defaultValue).withValues(values));
        }

        public Builder withRoutingTimeout(Duration routingTimeout) {
            this.routingTimeout = routingTimeout;
            return this;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        public StreetPreferences build() {
            StreetPreferences value = new StreetPreferences(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

